/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/

/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This file defines the constants used when utilizing the tabular weather
 * database file
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef WEATHER_DB_CONSTANTS_H_
#define WEATHER_DB_CONSTANTS_H_


/**************/
 /** INCLUDES **/
/**************/

#include "sms_api.h"


  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

/* Database File Name */
#define WEATHER_DATABASE_FOLDER "weather"
#define WEATHER_REF_DATABASE_FILENAMEA "weather_ref.db"
#define WEATHER_REF_DATABASE_FILENAMEB "weather_ref.b.db"

/* Location Database Table Names */
#define WEATHER_LOCATION_DATABASE_VERSION_TABLE_NAME "db_version"
#define WEATHER_LOCATION_DATABASE_TABLE_NAME "locations"
#define WEATHER_LOCATION_UPDATE_VERSION_TABLE_NAME "data_version"
#define WEATHER_RTREE_TABLE_NAME "locations_rtree"

/* Database Table Attributes */
#define WEATHER_DATABASE_FILE_VERSION (2)

/*  set fixed_constant [expr 1 << $binpoint]
    set rtree_range [expr .000015 * $fixed_constant] */
#define WEATHER_RTREE_RANGE      ((N32)62)

/* Database Queries */

// Select all from version
#define WEATHER_SELECT_DB_VERSION \
	"select * from "WEATHER_LOCATION_DATABASE_VERSION_TABLE_NAME";"

// Select all from version
#define WEATHER_SELECT_UPDATE_VERSION \
	"select * from "WEATHER_LOCATION_UPDATE_VERSION_TABLE_NAME";"

// Select weather stations by location and type
#define WEATHER_SELECT_LOCATIONS_BY_LOCATION_AND_TYPE \
    "select * from "WEATHER_LOCATION_DATABASE_TABLE_NAME" where id in " \
    "(select id from "WEATHER_RTREE_TABLE_NAME" where " \
    WEATHER_RTREE_TABLE_NAME".minLat>=%d and " \
    WEATHER_RTREE_TABLE_NAME".maxLat<=%d and " \
    WEATHER_RTREE_TABLE_NAME".minLon>=%d and " \
    WEATHER_RTREE_TABLE_NAME".maxLon<=%d) and ski_flag=%u order by id;"

// Select all from version
#define WEATHER_SELECT_LOCATION \
	"select * from "WEATHER_LOCATION_DATABASE_TABLE_NAME" where id=%u;"

// Select all from version
#define WEATHER_SELECT_LOCATION_WITH_FLAG \
	"select * from "WEATHER_LOCATION_DATABASE_TABLE_NAME" where id=%u and ski_flag=%u;"

// Select all locations with flag
#define WEATHER_SELECT_ALL_LOCATIONS_WITH_FLAG \
	"select * from "WEATHER_LOCATION_DATABASE_TABLE_NAME" where ski_flag=%u;"

// Select all locations with flag and area_name
#define WEATHER_SELECT_ALL_LOCATIONS_WITH_FLAG_AND_UPPER_AREA_NAME \
	"select * from "WEATHER_LOCATION_DATABASE_TABLE_NAME" where ski_flag=%u and UPPER(area_name) like ?||'%%';"


#define WEATHER_UPDATE_LOCATION_VERSION \
    "update "WEATHER_LOCATION_UPDATE_VERSION_TABLE_NAME" set version=%d;"

#define WEATHER_DELETE_LOCATION \
    "delete from "WEATHER_LOCATION_DATABASE_TABLE_NAME" where id=%u;"

#define WEATHER_DELETE_LOCATION_RTREE \
    "delete from "WEATHER_RTREE_TABLE_NAME" where id=%u;"

#define WEATHER_INSERT_LOCATION \
    "insert into "WEATHER_LOCATION_DATABASE_TABLE_NAME" " \
		"(id, version, latitude, longitude, area_name, icao_name, ski_flag)"\
		"values(?, ?, ?, ?, ?, ?, ?);"

#define WEATHER_INSERT_LOCATION_RTREE \
    "insert into "WEATHER_RTREE_TABLE_NAME" values(%u, %i, %i, %i, %i);"

#define WEATHER_MAX_AREA_NAME_STRING_LENGTH (80)
#define WEATHER_MAX_ICAO_NAME_STRING_LENGTH (4)
#define WEATHER_MAX_EXT_DATA_LENGTH (20)

/* Fixed-point format that should match the DB builder Tcl script */
#define WEATHER_LOCATION_LATLON_BINPOINT         (22)

// Constant used to size buffers used to perform
// DB queries.  Size is based on largest string
// size
#define WEATHER_MAX_SQL_STRING_LENGTH (300)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Enumeration specifying all the available fields
// in the db_version table
typedef enum db_version_fields_enum {
	DB_VERSION_FIELD_DSI = 0,
    DB_VERSION_FIELD_DB_VER,
    DB_VERSION_MAX_FIELDS
} DB_VERSION_FIELDS_ENUM;

// Enumeration specifying all the available fields
// in the location table
typedef enum location_fields_enum {
    LOCATION_FIELD_LOC_ID = 0,
    LOCATION_FIELD_VERSION,
    LOCATION_FIELD_LATITUDE,
    LOCATION_FIELD_LONGITUDE,
    LOCATION_FIELD_AREA_NAME,
    LOCATION_FIELD_ICAO_NAME,
    LOCATION_FIELD_SKI_FLAG,
    LOCATION_MAX_FIELDS
} LOCATION_FIELDS_ENUM;

// Enumeration specifying all the available fields
// in the location table
typedef enum update_version_fields_enum {
	UPDATE_VERSION = 0,
	UPDATE_VERSION_MAX_FIELDS
} UPDATE_VERSION_FIELDS_ENUM;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

// Structure which specifies all attributes
// of a single database version row that is
// available within the weather database
// These are the raw values that are retrieved from the database
typedef struct weather_version_row_struct
{
    UN8 un8DBVer;           // Database schema version
    DSI tDSI;				// USI
} WEATHER_VERSION_ROW_STRUCT;

typedef struct weather_location_row_struct
{
	LOC_ID tID;
	UN8 un8Version;
	OSAL_FIXED_OBJECT hLat;
	OSAL_FIXED_OBJECT_DATA atLatFixedData[OSAL_FIXED_OBJECT_SIZE];
	OSAL_FIXED_OBJECT hLon;
	OSAL_FIXED_OBJECT_DATA atLonFixedData[OSAL_FIXED_OBJECT_SIZE];
	STRING_OBJECT hAreaName;
	STRING_OBJECT hICAOName;
	BOOLEAN bSkiFlag;
} WEATHER_LOCATION_ROW_STRUCT;

typedef struct update_version_row_struct
{
	N16 n16Version;
} UPDATE_VERSION_ROW_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

// Union to group all the row definitions
// in a convenient manner
typedef union weather_location_db_row_union
{
	WEATHER_VERSION_ROW_STRUCT sVersion;
    WEATHER_LOCATION_ROW_STRUCT sLocation;
    UPDATE_VERSION_ROW_STRUCT sUpdateVersion;
} WEATHER_LOCATION_DB_ROW_UNION;


  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

#endif /* WEATHER_DB_CONSTANTS_H_ */
