/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/*                           Proprietary & Confidential                       */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:TuneMix header file.
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef TUNEMIX_OBJ_H_
#define TUNEMIX_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "sms_api.h"
#include "sms_event.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

// Minimum number of qualified music channels
#define TUNEMIX_CHANNELS_MIN 2
// Maximum number of components for TuneMix
#define TUNEMIX_CHANNELS_MAX 20

#define TUNEMIX_OBJECTS_MAX (10)
#define TUNEMIX_OBJECTS_NONE (0)

// Object name prefix for objects 
#define TUNEMIX_OBJECT_NAME "TUNEMIX"

// TuneMix Tag definitions

#define TUNEMIX_TAG_NAME "TuneMixChannel"
#define TUNEMIX_INDEX_TAG_NAME "Index"
#define TUNEMIX_NAME_TAG_NAME "Name"
#define TUNEMIX_ACTIVE_TAG_NAME "Active"
#define TUNEMIX_OVERRIDES_TAG_NAME "Overrides"
#define TUNEMIX_COMPONENTS_TAG_NAME "Components"
#define TUNEMIX_SERVICE_ID_TAG_NAME "ServiceId"

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
TUNEMIX_OBJECT TUNEMIX_hCreateFromTags (
   DECODER_OBJECT hDecoder,
    TAG_OBJECT hCurrentTMTAg,
    UN8 *pun8Index,
    BOOLEAN bBehaviorValue
        );

void TUNEMIX_vUpdateTuneMixStatus (
    DECODER_OBJECT hDecoder,
    CHANNEL_ID tTuneMixId,
    BOOLEAN bActive,
    TUNEMIX_STATUS_ENUM eStatus
        );

SERVICE_ID TUNEMIX_tGetSIDFromActiveTM (
    TAG_OBJECT hParentTag
        );

OSAL_OBJECT_HDL TUNEMIX_hGetComponentList(
    TUNEMIX_OBJECT hTuneMix
        );

BOOLEAN TUNEMIX_bSaveConfiguration (
    DECODER_OBJECT hDecoder,
    UN16 un16TuneMixId,
    SERVICE_ID atServiceId[],
    UN16 un16NumberOfServices
        );

void TUNEMIX_vDeallocate (
    TUNEMIX_OBJECT hTuneMix
        );

SMSAPI_RETURN_CODE_ENUM TUNEMIX_eQualified (
    TUNEMIX_OBJECT hTuneMix
        );

#endif /* TUNEMIX_OBJ_H */
