/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:TRAFFIC_MSG header file.
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef TRAFFIC_MSG_OBJ_H_
#define TRAFFIC_MSG_OBJ_H_



#include "sms_api.h"
#include "traffic_db_constants.h"
#include "alertc_event_obj.h"
#include "sql_interface_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/
#define ALERTC_MESSAGE_MIN_BYTE_LENGTH (5)

#define MAX_EVENT_DESCRIPTION_LENGTH (100)

// Max value for EXTENT field = 7
// Control Code 6 used to increase extent by 8
// Control Code 7 used to increase extent by 16
// 7+8+16 = 31
#define MAX_EXTENT_VALUE                (31)


  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
BOOLEAN TRAFFIC_MSG_bInstall (
    SMS_OBJECT hOwner,
    TRAFFIC_SERVICE_OBJECT hTrafficMgr
        );

void TRAFFIC_MSG_vUninstall (
    void
        );

TRAFFIC_POS_CODE TRAFFIC_MSG_tInitialPosCode (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

TRAFFIC_MARKET TRAFFIC_MSG_tMarket (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

TRAFFIC_BSA TRAFFIC_MSG_tBSA (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

UN8 TRAFFIC_MSG_un8InitialNumLocs (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

ALERTC_EVENT_TYPE_ENUM TRAFFIC_MSG_eAlertCType (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

N16 TRAFFIC_MSG_n16Equal(
    TRAFFIC_MSG_OBJECT hTrafficMsg1,
    TRAFFIC_MSG_OBJECT hTrafficMsg2
        );

BOOLEAN TRAFFIC_MSG_bAddLocation (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    LOCATION_OBJECT hLocation
        );

BOOLEAN TRAFFIC_MSG_bRemoveLocation (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    LOCATION_OBJECT hLocation,
    BOOLEAN *pbMsgDestroyed
        );

void TRAFFIC_MSG_vDestroy (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

TRAFFIC_MSG_OBJECT TRAFFIC_MSG_hCreateFromDB (
    SMS_OBJECT hOwner,
    TRAFFIC_STORAGE_ROW_STRUCT *psStorageRow
        );

BOOLEAN TRAFFIC_MSG_bWrittenToDB (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

void TRAFFIC_MSG_vSetWrittenToDBFlag (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    BOOLEAN bDBFlag
        );

UN32 TRAFFIC_MSG_un32TimeStamp (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

void TRAFFIC_MSG_vUpdateTimeStamp (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

BOOLEAN TRAFFIC_MSG_bInsertIntoDB (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    UN32 un32UnixTimeSecs,
    SQL_INTERFACE_OBJECT hSQL,
    SQL_PREPARED_STATEMENT_HANDLE *phStmt,
    SQL_BIND_PARAMETER_STRUCT *psStmtBindParams
        );

TRAFFIC_MSG_OBJECT TRAFFIC_MSG_hCreate (
    SMS_OBJECT hOwner,
    OSAL_BUFFER_HDL hPayload,
    TRAFFIC_LOCID_OBJECT hTrafficLocID
        );


#endif /* TRAFFIC_MSG_OBJ_H_ */
