/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:TRAFFIC_MSG_IMAGE header file.
 *
 ******************************************************************************/

#ifndef TRAFFIC_MSG_IMAGE_OBJ_H_
#define TRAFFIC_MSG_IMAGE_OBJ_H_

#include "sms_api.h"
#include "trafcam_interface.h"

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

TRAFFIC_MSG_OBJECT TRAFFIC_MSG_IMAGE_hCreate (
    SMS_OBJECT hOwner,
    size_t tDataSize,
    TRAFCAM_IMAGE_INFO_STRUCT *psImageInfo,
    const char *pacFilePath
        );

void TRAFFIC_MSG_IMAGE_vDestroy(
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

TRAFCAM_IMAGE_HASH TRAFFIC_MSG_IMAGE_tHash(
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

BOOLEAN TRAFFIC_MSG_IMAGE_bUpdateHash(
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    TRAFCAM_IMAGE_HASH tHash
        );

TRAFFIC_MSG_OBJECT TRAFFIC_MSG_IMAGE_hCreateDummy (
    SMS_OBJECT hOwner
        );

UN32 TRAFFIC_MSG_IMAGE_un32TimeToExpire(
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

BOOLEAN TRAFFIC_MSG_IMAGE_bUpdateTimeToExpire(
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

#endif /* TRAFFIC_MSG_IMAGE_OBJ_H_ */
