/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 *  This module contains the Object:TRAFFIC_MSG_BASE implementation for the
 *  Sirius Module Services (SMS)
 *
 ******************************************************************************/

#include "sms_api.h"
#include "_traffic_msg_base_obj.h"
#include "traffic_msg_base_obj.h"
#include "dsrl_entry_obj.h"


/*****************************************************************************
                             PUBLIC FUNCTIONS
*****************************************************************************/

/*****************************************************************************
*
*   eType
*
*****************************************************************************/
static TRAFFIC_MSG_TYPE_ENUM eType(
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    TRAFFIC_MSG_TYPE_ENUM eType  = TRAFFIC_MSG_TYPE_UNKNOWN;
    BOOLEAN bOwner;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if ((bOwner == TRUE) && (psObj->psIntf->eType != NULL))
    {
        eType =
            psObj->psIntf->eType((TRAFFIC_MSG_BASE_OBJECT)psObj->pvData);
    }

    return eType;
}


/*****************************************************************************
*
*   eClass
*
*****************************************************************************/
static TRAFFIC_MSG_CLASS_ENUM eClass (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    TRAFFIC_MSG_CLASS_ENUM eClass  = TRAFFIC_MSG_CLASS_UNKNOWN;
    BOOLEAN bOwner;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if ((bOwner == TRUE) && (psObj->psIntf->eClass != NULL))
    {
        eClass =
            psObj->psIntf->eClass((TRAFFIC_MSG_BASE_OBJECT)psObj->pvData);
    }

    return eClass;
}


/*****************************************************************************
*
*   eSpeed
*
*****************************************************************************/
static TRAFFIC_SPEED_ENUM eSpeed (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    TRAFFIC_SPEED_ENUM eSpeed  = TRAFFIC_SPEED_UNKNOWN;
    BOOLEAN bOwner;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if ((bOwner == TRUE) && (psObj->psIntf->eSpeed != NULL))
    {
        eSpeed =
            psObj->psIntf->eSpeed((TRAFFIC_MSG_BASE_OBJECT)psObj->pvData);
    }

    return eSpeed;
}


/*****************************************************************************
*
*   eDuration
*
*****************************************************************************/
static TRAFFIC_DURATION_ENUM eDuration (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    TRAFFIC_DURATION_ENUM eDuration  = TRAFFIC_DURATION_UNKNOWN;
    BOOLEAN bOwner;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if ((bOwner == TRUE) && (psObj->psIntf->eDuration != NULL))
    {
        eDuration = psObj->psIntf->eDuration(
            (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData);
    }

    return eDuration;
}


/*****************************************************************************
*
*   eDirection
*
*****************************************************************************/
static TRAFFIC_DIRECTION_ENUM eDirection (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    TRAFFIC_DIRECTION_ENUM eDirection  = TRAFFIC_DIRECTION_UNKNOWN;
    BOOLEAN bOwner;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if((bOwner == TRUE) && (psObj->psIntf->eDirection != NULL))
    {
        eDirection = psObj->psIntf->eDirection(
            (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData);
    }

    return eDirection;
}


/*****************************************************************************
*
*   hImage
*
*****************************************************************************/
static IMAGE_OBJECT hImage (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    IMAGE_OBJECT hImage  = IMAGE_INVALID_OBJECT;
    BOOLEAN bOwner;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if((bOwner == TRUE) && (psObj->psIntf->hImage != NULL))
    {
        hImage =
            psObj->psIntf->hImage((TRAFFIC_MSG_BASE_OBJECT)psObj->pvData);
    }

    return hImage;
}


/*****************************************************************************
*
*   eCameraDirection
*
*****************************************************************************/
static SMSAPI_RETURN_CODE_ENUM eCameraDirection (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    UN16 *pun16Direction
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    SMSAPI_RETURN_CODE_ENUM eReturnCode = SMSAPI_RETURN_CODE_NOT_OWNER;
    BOOLEAN bOwner;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if (bOwner == TRUE)
    {
        if (psObj->psIntf->eCameraDirection != NULL)
        {
            if (pun16Direction != NULL)
            {
                eReturnCode =
                    psObj->psIntf->eCameraDirection(
                    (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData, pun16Direction);
            }
            else
            {
                eReturnCode = SMSAPI_RETURN_CODE_INVALID_INPUT;
            }
        }
        else
        {
            eReturnCode = SMSAPI_RETURN_CODE_UNSUPPORTED_API;
        }
    }

    return eReturnCode;
}


/*****************************************************************************
*
*   bDiversionAdvised
*
*****************************************************************************/
static BOOLEAN bDiversionAdvised (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    BOOLEAN bOwner, bDiversionAdvised = FALSE;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if((bOwner == TRUE) && (psObj->psIntf->bDiversionAdvised != NULL))
    {
        bDiversionAdvised = psObj->psIntf->bDiversionAdvised(
            (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData);
    }

    return bDiversionAdvised;
}


/*****************************************************************************
*
*   tEventCode
*
*****************************************************************************/
static TRAFFIC_EVENT_CODE tEventCode (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    TRAFFIC_EVENT_CODE tEventCode = TRAFFIC_INVALID_EVENT_CODE;
    BOOLEAN bOwner;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if((bOwner == TRUE) && (psObj->psIntf->tEventCode != NULL))
    {
        tEventCode = psObj->psIntf->tEventCode(
            (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData);
    }

    return tEventCode;
}


/*****************************************************************************
*
*   hText
*
*****************************************************************************/
static STRING_OBJECT hText (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    STRING_OBJECT hText = STRING_INVALID_OBJECT;
    BOOLEAN bOwner;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if((bOwner == TRUE) && (psObj->psIntf->hText != NULL))
    {
        hText =
            psObj->psIntf->hText((TRAFFIC_MSG_BASE_OBJECT)psObj->pvData);
    }

    return hText;
}


/*****************************************************************************
*
*   hAdditionalText
*
*****************************************************************************/
static STRING_OBJECT hAdditionalText (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    STRING_OBJECT hAdditionalText = STRING_INVALID_OBJECT;
    BOOLEAN bOwner;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if((bOwner == TRUE) && (psObj->psIntf->hAdditionalText != NULL))
    {
        hAdditionalText = psObj->psIntf->hAdditionalText(
            (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData);
    }

    return hAdditionalText;
}


/*****************************************************************************
*
*   un32StartTime
*
*****************************************************************************/
static UN32 un32StartTime (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    UN32 un32StartTime = 0;
    BOOLEAN bOwner;

    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if((bOwner == TRUE) && (psObj->psIntf->un32StartTime != NULL))
    {
        un32StartTime = psObj->psIntf->un32StartTime(
            (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData);
    }

    return un32StartTime;
}


/*****************************************************************************
*
*   un32StopTime
*
*****************************************************************************/
static UN32 un32StopTime (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    UN32 un32StopTime = 0;
    BOOLEAN bOwner;

    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if((bOwner == TRUE) && (psObj->psIntf->un32StopTime != NULL))
    {
        un32StopTime = psObj->psIntf->un32StopTime(
            (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData);
    }

    return un32StopTime;
}


/*****************************************************************************
*
*   un8GetFreeFormData
*
*****************************************************************************/
static UN8 un8GetFreeFormData (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    ALERTC_FREEFORM_DATA_LABEL_ENUM eLabel,
    UN16 *paun16Values,
    size_t tCount
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    UN8 un8NumFound = 0;
    BOOLEAN bOwner;

    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);

    if ((bOwner == TRUE) && (psObj->psIntf->un8GetFreeFormData != NULL) &&
        (paun16Values != NULL))
    {
        un8NumFound = psObj->psIntf->un8GetFreeFormData(
            (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData,
            eLabel, paun16Values, tCount
                );
    }

    return un8NumFound;
}


/*****************************************************************************
*
*   un8NumLocations
*
*****************************************************************************/
static UN8 un8NumLocations (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    UN8 un8NumLocations = 0;
    BOOLEAN bOwner;

    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);

    if ((bOwner == TRUE) && (psObj->psIntf->un8NumLocations != NULL))
    {
        un8NumLocations = psObj->psIntf->un8NumLocations(
            (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData
                );
    }

    return un8NumLocations;
}


/*****************************************************************************
*
*   hGetLocation
*
*****************************************************************************/
static LOCATION_OBJECT hGetLocation (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    UN8 un8Index
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    LOCATION_OBJECT hLocation = LOCATION_INVALID_OBJECT;
    BOOLEAN bOwner;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);

    if ((bOwner == TRUE) && (psObj->psIntf->hGetLocation != NULL))
    {
        hLocation = psObj->psIntf->hGetLocation(
            (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData, un8Index
                );
    }

    return hLocation;
}


/*****************************************************************************
*
*   n32FPrintf
*
*****************************************************************************/
static N32 n32FPrintf (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    N32 n32Return = EOF;
    BOOLEAN bOwner;

    // Verify inputs.
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);

    if ((bOwner == TRUE) && (psObj->psIntf->n32FPrintf != NULL))
    {
        n32Return = psObj->psIntf->n32FPrintf(
            (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData, psFile, eOutputOption
                );
    }

    return n32Return;
}


/*****************************************************************************
*
*   eIterateLocations
*
*****************************************************************************/
static SMSAPI_RETURN_CODE_ENUM eIterateLocations (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    TRAFFIC_MSG_LOCATION_ITERATOR bIterator,
    void *pvIteratorArg
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj =
        (TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg;
    BOOLEAN bOwner;
    SMSAPI_RETURN_CODE_ENUM eReturnCode = SMSAPI_RETURN_CODE_NOT_OWNER;
    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);

    if(bOwner == TRUE)
    {
        if (psObj->psIntf->eIterateLocations == NULL)
        {
            eReturnCode = SMSAPI_RETURN_CODE_UNSUPPORTED_API;
        }
        else if (bIterator != NULL)
        {
            eReturnCode = psObj->psIntf->eIterateLocations(
                (TRAFFIC_MSG_BASE_OBJECT)psObj->pvData, bIterator,
                pvIteratorArg);
        }
        else
        {
            eReturnCode = SMSAPI_RETURN_CODE_INVALID_INPUT;
        }
    }

    return eReturnCode;
}


/*****************************************************************************
*
*   TRAFFIC_MSG_BASE_hCreate
*
*****************************************************************************/
TRAFFIC_MSG_OBJECT TRAFFIC_MSG_BASE_hCreate(
    void **ppvData,
    const char *pacName,
    SMS_OBJECT hParent,
    size_t tObjectDataSize,
    size_t tServiceDataSize,
    const TRAFFIC_MSG_BASE_OBJECT_INTERFACE_STRUCT *psIntf
        )
{
    TRAFFIC_MSG_BASE_STRUCT *psObj = NULL;

    psObj = (TRAFFIC_MSG_BASE_STRUCT *)DSRL_ENTRY_hCreate(pacName,
        DSRL_ENTRY_TYPE_TRAFFIC_MSG, sizeof(TRAFFIC_MSG_BASE_STRUCT) +
        tObjectDataSize, tServiceDataSize, hParent, FALSE);
    if (psObj != NULL)
    {
        psObj->psIntf = psIntf;
        psObj->pvData = (void *)(psObj + 1);
        if (ppvData != NULL)
        {
            *ppvData = psObj->pvData;
        }
    }

    return (TRAFFIC_MSG_OBJECT)psObj;
}


/*****************************************************************************
*
*   TRAFFIC_MSG_BASE_vDestroy
*
*****************************************************************************/
void TRAFFIC_MSG_BASE_vDestroy(
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    DSRL_ENTRY_vDestroy((DSRL_ENTRY_OBJECT)hTrafficMsg);

    return;
}


/*****************************************************************************
*
*   TRAFFIC_MSG_BASE_pvObjectData
*
*****************************************************************************/
void *TRAFFIC_MSG_BASE_pvObjectData(
    TRAFFIC_MSG_OBJECT hTrafficMsg
        )
{
    BOOLEAN bOwner;
    void *pvData = NULL;

    bOwner = DSRL_ENTRY_bOwner((DSRL_ENTRY_OBJECT)hTrafficMsg);
    if (bOwner == TRUE)
    {
        pvData = ((TRAFFIC_MSG_BASE_STRUCT *)hTrafficMsg)->pvData;
    }

    return pvData;
}
