/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:TRAFFIC_MGR header file.
 *
 ******************************************************************************/

#ifndef TRAFFIC_MGR_OBJ_H_
#define TRAFFIC_MGR_OBJ_H_

#include "sms_api.h"
#include "dataservice_mgr_obj.h"
#include "alertc_event_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

// The number of traffic markets supported by the traffic consortium
#define NUM_TRAFFIC_MARKETS (31)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
ALERTC_EVENT_OBJECT TRAFFIC_MGR_hGetAlertCEvent (
    TRAFFIC_SERVICE_OBJECT hTrafficService,
    TRAFFIC_EVENT_CODE tEventCode
        );

const char *TRAFFIC_MGR_pcGetSupplInfoText (
    TRAFFIC_SERVICE_OBJECT hTrafficService,
    ALERTC_SUPPL_INFO_CODE tCode
        );
#endif /* TRAFFIC_MGR_OBJ_H_ */
