/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This file defines the interface used for service-specific traffic parsers
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef TRAFFIC_INTERFACE_H_
#define TRAFFIC_INTERFACE_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "sms_api.h"
#include "sms_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/
  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef enum traffic_market_proc_state_enum {
    TRAFFIC_MARKET_PROC_STATE_UNKNOWN=0,
    TRAFFIC_MARKET_PROC_STATE_INCOMPLETE,
    TRAFFIC_MARKET_PROC_STATE_COMPLETE,
    TRAFFIC_MARKET_PROC_STATE_NATION_COMPLETE,
}TRAFFIC_MARKET_PROC_STATE_ENUM;

// Handle to the traffic interface object
typedef void * TRAFFIC_INTERFACE_OBJECT;
#define TRAFFIC_INTERFACE_INVALID_OBJECT (NULL)

// Interface function that handles create the private object data
// for the broadcast-specific data.
typedef TRAFFIC_INTERFACE_OBJECT (*TRAFFIC_INIT_BDCAST_SPEC_FUNC) (
    SMS_OBJECT hOwner
        );

// Configures the data filter in the hardware if need be by the service.
typedef BOOLEAN (*TRAFFIC_CONFIGURE_DATA_FILTER_FUNC) (
    TRAFFIC_INTERFACE_OBJECT hInterfaceObj,
    TRAFFIC_SERVICE_OBJECT hTrafficService,
    BOOLEAN bAdd,
    TRAFFIC_MARKET tMarket
        );

// Prepares the STI payload in order to parse out Alert-C
// This function will leave hPayload in such a state that there
// are only Alert-C messages in the payload.
typedef BOOLEAN (*TRAFFIC_PARSE_SERVICE_BITS_FROM_PAYLOAD_FUNC) (
    TRAFFIC_INTERFACE_OBJECT hInterfaceObj,
    OSAL_BUFFER_HDL *phPayload,
    BOOLEAN bNewPayload,
    TRAFFIC_LOCID_OBJECT *phTrafficID,
    TRAFFIC_MSG_TYPE_ENUM *peMsgType,
    TRAFFIC_MARKET_PROC_STATE_ENUM *peMarketProcState,
    size_t *ptNumAlertCBytes
        );

// Interface function that handles destroying the private object data
// for the broadcast-specific data.
typedef void (*TRAFFIC_UNINIT_BDCAST_SPEC_FUNC) (
    TRAFFIC_INTERFACE_OBJECT hInterfaceObj
        );

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

typedef struct traffic_plugin_interface_struct
{
    const DSI tDSI;

    const size_t tOTABufferByteSize;

    // Returns a handle to an object that contains
    // broadcast specific data used for parsing the traffic
    // data stream
    TRAFFIC_INIT_BDCAST_SPEC_FUNC hInitParser;

    // Configures the data filter in the hardware if need be by the service.
    // May be NULL if it isn't needed by the service.
    TRAFFIC_CONFIGURE_DATA_FILTER_FUNC bConfigureDataFilter;

    // Prepares the STI payload in order to parse out Alert-C
    // Must be non-null
    TRAFFIC_PARSE_SERVICE_BITS_FROM_PAYLOAD_FUNC bParseTrafficServiceBits;

    // Removes any resources that was created to aid in
    TRAFFIC_UNINIT_BDCAST_SPEC_FUNC vUninitParser;

} TRAFFIC_PLUGIN_INTERFACE_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

#endif /* TRAFFIC_INTERFACE_H_ */
