/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
* DESCRIPTION
*
* This is the Object:TEAM header file.
*
******************************************************************************/

#ifndef TEAM_OBJ_H_
#define TEAM_OBJ_H_

#include "standard.h"

#include "league_obj.h"
#include "sms_api.h"
#include "cid_obj.h"
#include "sql_interface_obj.h"

/**********************/
/** GLOBAL CONSTANTS **/
/**********************/

#define TEAM_INVALID_VERSION (-1)

/*********************/
/** GLOBAL TYPEDEFS **/
/*********************/

/*****************************/
/** GLOBAL STRUCT TEMPLATES **/
/*****************************/

/****************************/
/** GLOBAL UNION TEMPLATES **/
/****************************/

/**********************/
/** GLOBAL VARIABLES **/
/**********************/

/*******************/
/** GLOBAL MACROS **/
/*******************/

/***********************/
/** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN TEAM_bInitialize ( SMS_OBJECT hParent );

void TEAM_vUnInitialize ( void );

TEAM_OBJECT TEAM_hAdd (
    CID_OBJECT hTeamId,
    N32 n32Version,
    char const *pacName,
    char const *pacNickname,
    char const *pacAbbrev,
    size_t tNumLeagues,
    UN8 const *paun8Leagues,
    size_t tNumTiers,
    UN8 const *paun8Tiers
    );

BOOLEAN TEAM_bAddLeague (
    TEAM_OBJECT hTeam,
    LEAGUE_OBJECT hLeague
    );

UN32 TEAM_un32Count (
    N32 n32Version, 
    UN32 *pun32Total, 
    UN32 un32Expected
    );

TEAM_OBJECT TEAM_hFind (
    CID_OBJECT hTeamId
    );

BOOLEAN TEAM_bLoad ( 
    CID_ENUM eType
    );

N16 TEAM_n16CompareIds (
    TEAM_OBJECT hTeam1,
    TEAM_OBJECT hTeam2
    );

BOOLEAN TEAM_bSave ( N32 n32Version );

CID_OBJECT TEAM_hCreateCid(     
    CID_POOL hCidPool,
    const void *pvSrcObjectData
    );

BOOLEAN TEAM_bCreateDBTables (
    SQL_INTERFACE_OBJECT hSQLConnection,
    void *pvArg
    );

TEAM_OBJECT TEAM_hGetDummyObj (
    CID_OBJECT hTeamId
    );

BOOLEAN TEAM_bIterateLeagues(
    TEAM_OBJECT hTeam,
    LEAGUE_CONTENT_ITERATOR_CALLBACK bIteratorCallback,
    void *pvArg
        );

BOOLEAN TEAM_bIterateContent (
    LEAGUE_OBJECT hLeague,
    TEAM_CONTENT_ITERATOR_CALLBACK bContentIteratorCallback,
    void *pvContentIteratorCallbackArg
        );

#endif /* TEAM_OBJ_H */
