/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * Tag - Config Manager interface header file.
 *
 ******************************************************************************/

#ifndef TAG_CM_INTERFACE_H_
#define TAG_CM_INTERFACE_H_

#include "standard.h"
#include "sms_api.h"
#include "tag_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/
#define TAG_BEGIN_DELIMITER        "<"
#define TAG_END_DELIMITER          ">"
#define TAG_QUOTE                  "\""
#define TAG_DEFINITION_CLOSE_DELIMITER (char)'/'
#define TAG_INSTANCE_DELIMITER " name="
#define TAG_BEGIN_CLOSE_DELIMITER  "</"

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

TAG_OBJECT TAGCM_hGetParentTag(
    TAG_OBJECT hChildTag
        );

N32 TAGCM_n32WriteTagToFile(
    TAG_OBJECT hTag,
    FILE *psFile,
    N16 un16IndentLevel
        );

TAG_OBJECT TAGCM_hCreate (
    SMS_OBJECT hParent,
    const char *pacTagName,
    const char *pacTagInstanceName,
    STRING_OBJECT hTagValue
	    );

void TAGCM_vDestroy (
    TAG_OBJECT hTag
        );

#endif /* TAG_CM_INTERFACE_H_ */
