/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Obj:STRING header file.
 *
 ******************************************************************************/

#ifndef STRING_OBJ_H_
#define STRING_OBJ_H_

#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

STRING_OBJECT STRING_hCreate (
    SMS_OBJECT hSMS,
    const char *pacString,
    size_t tSize,
    size_t tMinimumLength
        );

STRING_OBJECT STRING_hCreateFromBuffer (
    SMS_OBJECT hSMS,
    OSAL_BUFFER_HDL hBuffer,
    UN8 un8CharBitSize,
    size_t tMaxNumCharsWithNull
        );

STRING_OBJECT STRING_hCreateConst (
    const char *pacString,
    size_t tSize
        );

void STRING_vDestroy (
    STRING_OBJECT hString
        );

STRING_OBJECT STRING_hDuplicate (
    SMS_OBJECT hParent,
    STRING_OBJECT hSrcString
        );

BOOLEAN STRING_bDecodeAndModifyCStr (
    STRING_OBJECT hString,
    const char *pacSrc
        );

N32 STRING_n32FWrite (
    STRING_OBJECT hString,
    FILE *psFile,
    BOOLEAN bDoEncoding
        );

STRING_OBJECT STRING_hFRead (
    SMS_OBJECT hParent,
    FILE *psFile
        );

BOOLEAN STRING_bCapitalize (
    STRING_OBJECT hString
        );

BOOLEAN STRING_bToUpper (
    STRING_OBJECT hString
        );

#endif /* STRING_OBJ_H */
