/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*            Licensed Materials - Property of Sirius XM Radio, Inc.          */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef STOCK_MSG_OBJ_H_
#define STOCK_MSG_OBJ_H_

#include "sms_api.h"
#include "stock_ticker_interface.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

// Defines mask to indicate filled fields in the
// STOCK_MSG_DATA_STRUCT
typedef UN8 STOCK_MSG_DATA_MASK;
#define STOCK_MSG_DATA_NONE      ((STOCK_MSG_DATA_MASK) 0x00)
#define STOCK_MSG_DATA_INDEX     ((STOCK_MSG_DATA_MASK) 0x01)
#define STOCK_MSG_DATA_NAME      ((STOCK_MSG_DATA_MASK) 0x02)
#define STOCK_MSG_DATA_NAME_CSTR ((STOCK_MSG_DATA_MASK) 0x04)
#define STOCK_MSG_DATA_VALUES    ((STOCK_MSG_DATA_MASK) 0x08)
#define STOCK_MSG_DATA_NAME_ALL  ((STOCK_MSG_DATA_MASK) (\
                                     STOCK_MSG_DATA_NAME      | \
                                     STOCK_MSG_DATA_NAME_CSTR   \
                                          ))
  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef struct stock_msg_data_struct
{
    // Mask
    STOCK_MSG_DATA_MASK tMask;

    // Stock index
    STOCK_ID tIndex;

    // Values
    struct
    {
        STOCK_MSG_STATE_ENUM eState;
        STOCK_TICKER_QUOTE_STRUCT sQuote;
    } sValues;

    // Name
    union
    {
        // C-str
        struct
        {
            const char *pacValue;
            size_t tValueLength;
        } sCStr;

        // Name (String Object)
        STRING_OBJECT hValue;
    } uName;

} STOCK_MSG_DATA_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

STOCK_TICKER_RETURN_CODE_ENUM STOCK_MSG_eCreate(
    STOCK_MSG_OBJECT *phMsg,
    SMS_OBJECT hParent,
    STOCK_MSG_DATA_STRUCT *psData,
    size_t tDescriptorSize
        );

STOCK_TICKER_RETURN_CODE_ENUM STOCK_MSG_eCreateDummy(
    STOCK_MSG_OBJECT *phMsg,
    SMS_OBJECT hParent
        );

STOCK_TICKER_RETURN_CODE_ENUM STOCK_MSG_eSetIndex(
    STOCK_MSG_OBJECT hMsg,
    STOCK_ID tIndex
        );

BOOLEAN STOCK_MSG_bHasName(
    STOCK_MSG_OBJECT hMsg
        );

STOCK_TICKER_RETURN_CODE_ENUM STOCK_MSG_eUpdate(
    STOCK_MSG_OBJECT hMsg,
    STOCK_MSG_DATA_STRUCT *psData
        );

BOOLEAN STOCK_MSG_bGoodToPopulate(
    STOCK_MSG_OBJECT hMsg
        );

STOCK_ID STOCK_MSG_tIndex (
    STOCK_MSG_OBJECT hMsg
       );

STOCK_MSG_STATE_ENUM STOCK_MSG_eState (
    STOCK_MSG_OBJECT hMsg
       );

void STOCK_MSG_vDestroy (
    STOCK_MSG_OBJECT hMsg
        );

#endif /* STOCK_MSG_OBJ_H_ */
