/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SPORTS_SERVICE_MGR header file.
 *
 ******************************************************************************/

#ifndef SPORTS_SERVICE_MGR_OBJ_H_
#define SPORTS_SERVICE_MGR_OBJ_H_

#include "sms_api.h"

#ifndef SPORTS_SERVICE_DEBUG
#define SPORTS_SERVICE_DEBUG 0
#endif // SPORTS_SERVICE_DEBUG

// Comment out to exclude from output.  If you add a new one add the ndef set to
// zero clause below.

// Manager
//#define SSDL_MGR_SC_UPDATE (1)
//#define SSDL_MGR_AF_UPDATE (1)
//#define SSDL_MGR_TD_UPDATE (1)
//#define SSDL_MGR_DI_UPDATE (1)
//#define SSDL_MGR_LIFE_CYCLE (1)
//#define SSDL_MGR_STATE (1)
//#define SSDL_MGR_DBG_CMD (1)
//#define SSDL_MGR_PRUNE (1)

// Highband
//#define SSDL_HB_SC_UPDATE (1)
//#define SSDL_HB_TD_UPDATE (1)
//#define SSDL_HB_AF_UPDATE (1)
//#define SSDL_HB_DI_UPDATE (1)
//#define SSDL_HB_TREF (1)
//#define SSDL_HB_OVERRIDES (1)
//#define SSDL_HB_PARSING (1)
//#define SSDL_HB_AU_PROCESSING (1)
//#define SSDL_HB_LIFE_CYCLE (1)

//
// Defaults
//

// Manager
#ifndef SSDL_MGR_SC_UPDATE
#define SSDL_MGR_SC_UPDATE (0)
#endif

#ifndef SSDL_MGR_AF_UPDATE
#define SSDL_MGR_AF_UPDATE (0)
#endif

#ifndef SSDL_MGR_TD_UPDATE
#define SSDL_MGR_TD_UPDATE (0)
#endif

#ifndef SSDL_MGR_DI_UPDATE
#define SSDL_MGR_DI_UPDATE (0)
#endif

#ifndef SSDL_MGR_LIFE_CYCLE
#define SSDL_MGR_LIFE_CYCLE (0)
#endif

#ifndef SSDL_MGR_STATE
#define SSDL_MGR_STATE (0)
#endif

#ifndef SSDL_MGR_DBG_CMD
#define SSDL_MGR_DBG_CMD (0)
#endif

#ifndef SSDL_MGR_PRUNE
#define SSDL_MGR_PRUNE (0)
#endif

// Highband
#ifndef SSDL_HB_SC_UPDATE
#define SSDL_HB_SC_UPDATE (0)
#endif

#ifndef SSDL_HB_TD_UPDATE
#define SSDL_HB_TD_UPDATE (0)
#endif

#ifndef SSDL_HB_AF_UPDATE
#define SSDL_HB_AF_UPDATE (0)
#endif

#ifndef SSDL_HB_TREF
#define SSDL_HB_TREF (0)
#endif

#ifndef SSDL_HB_DI_UPDATE
#define SSDL_HB_DI_UPDATE (0)
#endif

#ifndef SSDL_HB_OVERRIDES
#define SSDL_HB_OVERRIDES (0)
#endif

#ifndef SSDL_HB_PARSING
#define SSDL_HB_PARSING (0)
#endif

#ifndef SSDL_HB_AU_PROCESSING
#define SSDL_HB_AU_PROCESSING (0)
#endif

#ifndef SSDL_HB_LIFE_CYCLE
#define SSDL_HB_LIFE_CYCLE (0)
#endif


#if SPORTS_SERVICE_DEBUG == 0

#ifdef SPORTS_SERVICE_MGR_vPrint
#undef SPORTS_SERVICE_MGR_vPrint
#endif

#ifdef SPORTS_SERVICE_MGR_vPrintSilent
#undef SPORTS_SERVICE_MGR_vPrintSilent
#endif

#if __STDC_VERSION__ >= 199901L
    #define SPORTS_SERVICE_MGR_vPrint(...)
    #define SPORTS_SERVICE_MGR_vPrintSilent(...)
#else
    #define SPORTS_SERVICE_MGR_vPrint if(1);else SPORTS_SERVICE_MGR_vPrintDummy
    #define SPORTS_SERVICE_MGR_vPrintSilent if(1);else SPORTS_SERVICE_MGR_vPrintDummy
#endif

#endif // SPORTS_SERVICE_DEBUG == 0

/**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

SPORTS_MONITOR_OBJECT SPORTS_SERVICE_MGR_hMonitorCreate (
    SPORTS_SERVICE_OBJECT hService,
    SPORTS_MONITOR_CALLBACK vCallback,
    void *pvCallbackArg
        );

SMSAPI_RETURN_CODE_ENUM SPORTS_SERVICE_MGR_eMonitorGetEventMask (
    SPORTS_SERVICE_OBJECT hService,
    SPORTS_MONITOR_OBJECT hMonitor,
    SPORTS_MONITOR_EVENT_MASK *ptEventMask
        );

SMSAPI_RETURN_CODE_ENUM SPORTS_SERVICE_MGR_eMonitorSetEventMask (
    SPORTS_SERVICE_OBJECT hService,
    SPORTS_MONITOR_OBJECT hMonitor,
    SPORTS_MONITOR_EVENT_MASK tEventMask
        );

void SPORTS_SERVICE_MGR_vMonitorDestroy (
    SPORTS_SERVICE_OBJECT hService,
    SPORTS_MONITOR_OBJECT hMonitor
        );

SMSAPI_RETURN_CODE_ENUM SPORTS_SERVICE_MGR_eMonitorSetAffiliateMask (
    SPORTS_SERVICE_OBJECT hService,
    SPORTS_MONITOR_OBJECT hMonitor,
    AFFILIATE_ID tAffiliate,
    SPORTS_MONITOR_EVENT_MASK tEventMask
        );

SMSAPI_RETURN_CODE_ENUM SPORTS_SERVICE_MGR_eMonitorGetAffiliateMask (
    SPORTS_SERVICE_OBJECT hService,
    SPORTS_MONITOR_OBJECT hMonitor,
    AFFILIATE_ID tAffiliate,
    SPORTS_MONITOR_EVENT_MASK *ptEventMask
        );

SMSAPI_RETURN_CODE_ENUM SPORTS_SERVICE_MGR_eMonitorRemoveAllAffiliates (
    SPORTS_SERVICE_OBJECT hService,
    SPORTS_MONITOR_OBJECT hMonitor
        );

SMSAPI_RETURN_CODE_ENUM SPORTS_SERVICE_MGR_eIterateChangedAffiliates (
    SPORTS_SERVICE_OBJECT hService,
    SPORTS_MONITOR_OBJECT hMonitor,
    SPORT_MONITOR_ITERATOR bIterator,
    void *pvIteratorArg
        );

#if SPORTS_SERVICE_DEBUG == 0
void SPORTS_SERVICE_MGR_vPrintDummy(
    UN32 un32DebugLevels,
    const char *pcFormat,
    ...
    );
#else
void SPORTS_SERVICE_MGR_vPrint(
    UN32 un32DebugLevels,
    const char *pcFormat,
    ...
    );

void SPORTS_SERVICE_MGR_vPrintSilent(
    UN32 un32DebugLevels,
    const char *pcFormat,
    ...
    );
#endif

#endif /* SPORTS_SERVICE_MGR_OBJ_H_ */
