/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SPORTS_FLASH header file.
 *
 ******************************************************************************/

#ifndef SPORTS_FLASH_OBJ_H_
#define SPORTS_FLASH_OBJ_H_

#include "sms_api.h"

/**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef struct sports_flash_object * SPORTS_FLASH_OBJECT;
#define SPORTS_FLASH_INVALID_OBJECT (SPORTS_FLASH_OBJECT)NULL

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN SPORTS_FLASH_bEventHandler (
    SPORTS_FLASH_OBJECT hSportsFlash,
    const SMS_EVENT_SPORTS_FLASH_STRUCT *psEventData
        );

BOOLEAN SPORTS_FLASH_bHandleGameEvent (
    DECODER_OBJECT hDecoder,
    const SPORTS_FLASH_EVENT_GAME_EVENT_STRUCT *psGameEvent
        );

BOOLEAN SPORTS_FLASH_bHandleFlashEvent (
    DECODER_OBJECT hDecoder,
    const SPORTS_FLASH_EVENT_FLASH_EVENT_STRUCT *psFlashEvent
        );

void SPORTS_FLASH_vUpdateFlashPlaybackStatus (
    DECODER_OBJECT hDecoder,
    SPORTS_FLASH_EVENT_ID tFlashEventId
        );

void SPORTS_FLASH_vStop (
    SPORTS_FLASH_OBJECT hSportsFlash
        );

#endif /* SPORTS_FLASH_OBJ_H_ */
