/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 *  This module contains the SONG TAG ID implementation for the
 *  Sirius Module Services (SMS)
 *
 ******************************************************************************/

#include <string.h>
#include <stdarg.h>

#include "standard.h"
#include "osal.h"

// Include things I need from SMS
#include "sms_version.h"
#include "sms_api.h"
#include "sms_obj.h"

#include "music_obj.h"

#include "cme.h"
#include "cdo_obj.h"

// Include SONG TAG ID module headers
#include "song_tag_id.h"
#include "_song_tag_id.h"



/*****************************************************************************
                             PUBLIC FUNCTIONS
*****************************************************************************/

/*****************************************************************************
                             PRIVATE FUNCTIONS
*****************************************************************************/

/*****************************************************************************
*
*   bParseSongTagId
*
*****************************************************************************/
static BOOLEAN bParseSongTagId (
    CD_OBJECT hCDO,
    const void *pvData
        )
{
    BOOLEAN bUpdated = FALSE;

    // Verify this CDO's type is MUSIC. Anything other than MUSIC
    // makes no sense for an Song Tag Id, at least for now ...
    if(CDO.eType(hCDO) == CDO_MUSIC)
    {
        MUSIC_OBJECT_STRUCT *psObj;

        // Go get MUSIC CDO structure from provided CDO
        psObj = (MUSIC_OBJECT_STRUCT *)CDO_pvContentData(hCDO);
        if(psObj != NULL)
        {
            // Process  Song Tag ID...
            // Check if provided Song Tag ID is null. If so we do not need to
            // process the Song Tag ID. If not, we need to process it.
            if(pvData != NULL)
            {
                CID_OBJECT *phCid;
                SONG_TAG_ID_PARSE_STRUCT *psStruct =
                    (SONG_TAG_ID_PARSE_STRUCT *)pvData;

                switch(psStruct->eService)
                {
                    case SONG_TAG_SERVICE_ITUNES:
                    {
                        phCid = &psObj->sSongTag.hITunesTagId;
                    }
                    break;

                    case SONG_TAG_SERVICE_INVALID:
                    default:
                    {
                        phCid = NULL;
                    }
                    break;
                }

                if (phCid != NULL)
                {
                    // Update content if it exists, otherwise if not...create it
                    bUpdated =
                        CME_bUpdateContent(hCDO, CID_SONG_TAG_ID,
                                           psStruct->pvData, phCid);
                }
            }
        }
    }

    return bUpdated;
}



