/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SMS Update header file.
 *
 ******************************************************************************/

#ifndef SMS_UPDATE_H_
#define SMS_UPDATE_H_

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

#define SMS_OBJECT_EVENT_NONE  ((SMSAPI_EVENT_MASK)0)
#define SMS_OBJECT_EVENT_ALL   (~(SMSAPI_EVENT_MASK)0)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct smsu_event_struct
{
    // Object update masks
    SMSAPI_EVENT_MASK tMask;
    SMSAPI_EVENT_MASK tPolledMask;
    SMSAPI_EVENT_MASK tFilterMask;
    SMSAPI_EVENT_MASK tInitialMask;

    // Object update callback list
    OSAL_OBJECT_HDL hCallbackList;
    OSAL_LINKED_LIST_ENTRY hCurCallback;

    // Object being updated
    void *pvObject;

    // Flag to indicate if any inactive callbacks exist
    BOOLEAN bInActiveCallbacks;

} SMSU_EVENT_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

void SMSU_vInitialize (
    SMSU_EVENT_STRUCT *psEvent,
    void *pvObject,
    SMSAPI_EVENT_MASK tInitialMask,
    SMSAPI_EVENT_MASK tRequestMask,
    SMSAPI_OBJECT_EVENT_CALLBACK vCallback,
    void *pvCallbackArg
        );

BOOLEAN SMSU_bNotify (
    SMSU_EVENT_STRUCT *psEvent
        );

BOOLEAN SMSU_bNotifyCallback (
    SMSU_EVENT_STRUCT *psEvent,
    SMSAPI_OBJECT_EVENT_CALLBACK vCallback,
    void *pvCallbackArg
        );

__INLINE__ SMSAPI_EVENT_MASK SMSU_tMask (
    SMSU_EVENT_STRUCT *psEvent
        );

SMSAPI_EVENT_MASK SMSU_tUpdate (
    SMSU_EVENT_STRUCT *psEvent,
    SMSAPI_EVENT_MASK tEventMask
        );

SMSAPI_EVENT_MASK SMSU_tUpdateAll (
    SMSU_EVENT_STRUCT *psEvent
        );

__INLINE__ SMSAPI_EVENT_MASK SMSU_tFilter (
    SMSU_EVENT_STRUCT *psEvent,
    SMSAPI_EVENT_MASK tFilterMask
        );

__INLINE__ SMSAPI_EVENT_MASK SMSU_tUnFilter (
    SMSU_EVENT_STRUCT *psEvent,
    SMSAPI_EVENT_MASK tUnFilterMask
        );

BOOLEAN SMSU_bModifyRequestMask (
    SMSU_EVENT_STRUCT *psEvent,
    SMSAPI_OBJECT_EVENT_CALLBACK vCallback,
    void *pvCallbackArg,
    SMSAPI_EVENT_MASK tNewRequestMask,
    SMSAPI_MODIFY_EVENT_MASK_ENUM eModification
        );

BOOLEAN SMSU_bRegisterCallback (
    SMSU_EVENT_STRUCT *psEvent,
    SMSAPI_EVENT_MASK tRequestMask,
    SMSAPI_OBJECT_EVENT_CALLBACK vCallback,
    void *pvCallbackArg,
    BOOLEAN bSetInitialEvents
        );

BOOLEAN SMSU_bIsCallbackPending (
    SMSU_EVENT_STRUCT *psEvent,
    SMSAPI_OBJECT_EVENT_CALLBACK vCallback,
    void *pvCallbackArg
        );

BOOLEAN SMSU_bUnregisterCallback (
    SMSU_EVENT_STRUCT *psEvent,
    SMSAPI_OBJECT_EVENT_CALLBACK vCallback,
    void *pvCallbackArg
        );

void SMSU_vDestroy (
    SMSU_EVENT_STRUCT *psEvent
        );



#endif /* SMS_UPDATE_H */
