/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SMS Task header file.
 *
 ******************************************************************************/

#ifndef SMS_OBJ_H_
#define SMS_OBJ_H_

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

#include "standard.h"
#include "sms_api.h"

/*
 Check what level of validity and ownership checks should be made
 In DEBUG builds we should always turns these on. In RELEASE
 builds they should be turned off to provide more efficient
 run-time execution.

 We also add yet another option that is we also can choose to
 live dangerously, where we can in DEBUG builds forego checking.
 This is used just for debugging the debug code.
 */

#if ((SMS_DEBUG != 0) && (LIVE_DANGEROUSLY != 1))
#define SMSO_INCLUDE_OBJECT_CHECKING 1
#else
#define SMSO_INCLUDE_OBJECT_CHECKING 0
#endif

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

extern void OSALM_vPrintMemoryBlock(void *pvObj);

/* Object Friend Prototypes */

SMS_OBJECT SMSO_hCreate (
    const char *pacName,
    size_t tSize,
    SMS_OBJECT hParent,
    BOOLEAN bLock
        );

void SMSO_vDestroy (
    SMS_OBJECT hSMS
        );

SMS_OBJECT SMSO_hParent (
    SMS_OBJECT hSMS
        );

BOOLEAN SMSO_bLock (
    SMS_OBJECT hSMS,
    N32 n32Timeout
        );

void SMSO_vUnlock (
    SMS_OBJECT hSMS
        );

#if SMSO_INCLUDE_OBJECT_CHECKING == 1

    // Use prototype for real function if object checking
    // is enabled.
    BOOLEAN SMSO_bValid (
        SMS_OBJECT hSMS
            );

#else

    // Do not perform deep check or enforce (use macro replacement)
    #define SMSO_bValid(x) ((x) != NULL)

#endif

BOOLEAN SMSO_bIsValid (
    SMS_OBJECT hSMS
        );

BOOLEAN SMSO_bOwner (
    SMS_OBJECT hSMS
        );

BOOLEAN SMSO_bTaskOwner (
    SMS_OBJECT hSMS,
    OSAL_TASK_ID tTask
        );

BOOLEAN SMSO_bIsOwner (
    SMS_OBJECT hSMS
        );

#endif /* SMS_OBJ_H */
