/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SMS header file.
 *
 ******************************************************************************/

#ifndef SMS_H_
#define SMS_H_

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "sms_event_types.h"
#include "song_tag_service.h"
#include "tag_obj.h"
#include "device_obj.h"
#include "srh.h"

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// SMS Object Operational Mode
typedef UN8 SMS_MODE_MASK;

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

// Operational Mode Mask Values
#define SMS_MODE_NONE               ( (SMS_MODE_MASK) 0x00 )
#define SMS_MODE_PARENT_ASSOCIATED  ( (SMS_MODE_MASK) 0x01 )
#define SMS_MODE_STOPPING           ( (SMS_MODE_MASK) 0x02 )
#define SMS_MODE_RESET              ( (SMS_MODE_MASK) 0x04 )
#define SMS_MODE_PARENT_ADDED       ( (SMS_MODE_MASK) 0x08 )

  /******************/
 /** GLOBAL ENUMS **/
/******************/

typedef enum sms_version_compare_enum {
    SMS_VERSION_LESSER = 0,
    SMS_VERSION_EQUAL,
    SMS_VERSION_GREATER,
    SMS_VERSION_COMPARISON_INVALID

} SMS_VERSION_COMPARE_ENUM;

typedef enum sms_object_release_initiator_enum
{
    SMS_OBJECT_RELEASE_BY_APP,
    SMS_OBJECT_RELEASE_BY_PARENT,
    SMS_OBJECT_RELEASE_BY_OTHERS

} SMS_OBJECT_RELEASE_INITIATOR_ENUM;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/


typedef BOOLEAN (*SMS_DESCRIPTOR_DISPATCH_CALLBACK)(
    void *pvDescriptor,
    SMS_EVENT_TYPE_ENUM eType,
    void *pvEventArg
        );

typedef struct sms_descriptor_dispatch_struct
{
    // Event type to dispatch
    SMS_EVENT_TYPE_ENUM eType;

    // Argument to dispatch
    void *pvEventArg;

    // Dispatcher callback
    SMS_DESCRIPTOR_DISPATCH_CALLBACK bDispatch;

} SMS_DESCRIPTOR_DISPATCH_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/
typedef union sms_behavior_value_union
{
    BOOLEAN bValue;
} SMS_BEHAVIOR_VALUE_UNION;

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN SMS_bIsInitialized ( void );

BOOLEAN SMS_bGetBehavior(
    int iBehavior,
    SMS_BEHAVIOR_VALUE_UNION *puValue
        );

BOOLEAN SMS_bLock ( void );

void SMS_vUnLock ( void );

BOOLEAN SMS_bAddSRM (
    SRM_OBJECT hSRM
        );

BOOLEAN SMS_bRemoveSRM (
    SRM_OBJECT hSRM
        );

SRM_OBJECT SMS_hSRM(
    const char *pacDriverName,
    const char *pacSRMName
        );

BOOLEAN SMS_bLoadDeviceGroup (
    FILE *psDevice
        );

BOOLEAN SMS_bDeviceGroup (
    DEVICE_GROUP *ptDeviceGroup
        );

typedef SMS_OBJECT (*SMS_CREATE_DSM_CHILD_CALLBACK) (
    SMS_OBJECT hDSMCtrl,
    void *pvCallbackArg
        );

SMS_OBJECT SMS_hCreateDSMChildObject (
    SMS_CREATE_DSM_CHILD_CALLBACK hCallback,
    void *pvCallbackArg
        );

SMS_EVENT_HDL SMS_hAllocateDSMEvent (
    SMS_EVENT_TYPE_ENUM eEvent,
    void **ppvData,
    EVENT_OPTIONS_TYPE tOptions
        );

DEVICE_OBJECT SMS_hDevice ( void );

SMS_OBJECT SMS_hUseDSMCtrl ( void );

const char *SMS_pacGetPath ( void );

TAG_OBJECT SMS_hGetTag ( void );

SONG_TAG_OBJECT SMS_hSongTagService ( void );

SMS_VERSION_COMPARE_ENUM SMS_eCompareVersions (
        size_t   tVersionBitWidth,
        UN32     un32VersionA,
        UN32     un32VersionB,
        BOOLEAN *pbRolloverIndication
    );

#endif /* SMS_H */
