/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/*                           Proprietary & Confidential                       */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:Smart Favorites header file.
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef SMART_FAVORITES_OBJ_H_
#define SMART_FAVORITES_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "sms_api.h"
#include "sms_event.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef struct smart_favorites_object * SMART_FAVORITES_OBJECT;
#define SMART_FAVORITES_INVALID_OBJECT (SMART_FAVORITES_OBJECT)NULL

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN SMART_FAVORITES_bEventHandler (
    DECODER_OBJECT hDecoder,
    SMART_FAVORITES_OBJECT hSmartFavorites,
    const SMS_EVENT_SMART_FAVORITES_STRUCT *psEventData
        );

BOOLEAN SMART_FAVORITES_bIsPresetsSync (
    DECODER_OBJECT hDecoder
        );

#endif /* SMART_FAVORITES_OBJ_H */
