/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SEEK header file.
 *
 ******************************************************************************/

#ifndef SEEK_H_
#define SEEK_H_

#include "tag_obj.h"
#include "seek_content.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/
#define SEEK_REGISTERED_CONTENT     "RegisteredContent"

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// the interface for service specific functions
typedef struct seek_service_specific_interface_struct
{
    // Initialize Method
    BOOLEAN (*bInit) (
        SEEK_SERVICE_OBJECT hSeek
            );

    // Uninitialize Method
    void (*vUnInit) (
        SEEK_SERVICE_OBJECT hSeek
            );

    // Printer
    N32 (*n32FPrintf) (
        SEEK_SERVICE_OBJECT hSeek,
        FILE *psFile,
        SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
            );

    // Handle Seek Alert Method
    BOOLEAN (*bHandleSeekAlert) (
        SEEK_SERVICE_OBJECT hSeek,
        CAL_ALERT_OBJECT hAlert
            );

} SEEK_SERVICE_SPECIFIC_INTERFACE_STRUCT;

//  The structure which contains information about a specific seek service
// (for example Artist/Title)
typedef struct seek_service_specific_info_struct
{
    // the specific service this is
    SEEK_SERVICE_ENUM eService;

    // the specific service interface
    const SEEK_SERVICE_SPECIFIC_INTERFACE_STRUCT *psInterface;

    // the specific service content interface
    const SEEK_CONTENT_OBJ_INTERFACE_STRUCT *psContentInterface;

} SEEK_SERVICE_SPECIFIC_INFO_STRUCT;


//  The main Seek Service (SEEK_SERVICE) structure
typedef struct seek_service_object_struct
{
    // The CAL tassociated with this service
    CAL_OBJECT hSeekList;

    // the cal_content object currently being iterated in the SeekList CAL
    CAL_CONTENT_OBJECT hCurrentlyIteratedContent;

    // indication of whether the service is enabled or not
    SEEK_STATE_ENUM eState;

    // service specific info struct
    SEEK_SERVICE_SPECIFIC_INFO_STRUCT *psInfo;

    // config manager tag
    TAG_OBJECT hTag;

    // string objects used for persistence
    STRING_OBJECT hEnabledString;
    STRING_OBJECT hDisabledString;

} SEEK_SERVICE_OBJECT_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

const SEEK_CONTENT_OBJ_INTERFACE_STRUCT *SEEK_psServiceSpecificContentInterface(
    SEEK_SERVICE_OBJECT hSeekService
        );

SEEK_SERVICE_ENUM SEEK_eService (
    SEEK_SERVICE_OBJECT hSeekService
        );

void SEEK_vStop(
    SEEK_SERVICE_OBJECT hSeekService
        );

#endif /* SEEK_H_ */
