/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*            Licensed Materials - Property of Sirius XM Radio, Inc.          */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SAFECAM_LOCATION header file.
 *
 ******************************************************************************/

#ifndef SAFECAM_LOCATION_OBJ_H_
#define SAFECAM_LOCATION_OBJ_H_


#include "sms_api.h"
#include "safecam_db_constants.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/


  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/


  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

SAFETY_CAMERAS_LOCATION_OBJECT SAFECAM_LOCATION_hCreate(
	SMS_OBJECT hParent,
    SAFECAM_ALERT_LOCATIONS_ROW_STRUCT *psAlertLocationRow,
    size_t tDescriptorSize
		);

SAFETY_CAMERAS_LOCATION_OBJECT SAFECAM_LOCATION_hCreateDummy(
    SMS_OBJECT hParent
        );

BOOLEAN SAFECAM_LOCATION_bSetUID(
    SAFETY_CAMERAS_LOCATION_OBJECT hSafeCamLoc,
    UN32 un32UID
        );

void SAFECAM_LOCATION_vDestroy (
	SAFETY_CAMERAS_LOCATION_OBJECT hSafeCamLoc
		);

BOOLEAN SAFECAM_LOCATION_bSetSubLocation(
	SAFETY_CAMERAS_LOCATION_OBJECT hSafeCamLoc,
	SAFETY_CAMERAS_SUBLOCATION_OBJECT hSafeCamSubLoc
		);

UN32 SAFECAM_LOCATION_un32UID (
	SAFETY_CAMERAS_LOCATION_OBJECT hSafeCamLoc
		);

void SAFECAM_LOCATION_vSetInitCompleted (
	SAFETY_CAMERAS_LOCATION_OBJECT hSafeCamLoc
		);

BOOLEAN SAFECAM_LOCATION_bInitCompleted (
	SAFETY_CAMERAS_LOCATION_OBJECT hSafeCamLoc
		);

BOOLEAN SAFECAM_LOCATION_bSpeedInMiles (
	SAFETY_CAMERAS_LOCATION_OBJECT hSafeCamLoc
		);

#endif /* SAFECAM_LOCATION_OBJ_H_ */
