/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*            Licensed Materials - Property of Sirius XM Radio, Inc.          */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Safety Camera Interface header file.
 *
 ******************************************************************************/

#ifndef SAFECAM_INTERFACE_H_
#define SAFECAM_INTERFACE_H_

#include "standard.h"
#include "osal.h"
#include "sms_api.h"
#include "safecam_db_constants.h"
#include "rfd_interface_obj.h"
#include "sql_interface_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Interface handle
typedef void * SAFECAM_INTERFACE_OBJECT;
#define SAFECAM_INTERFACE_INVALID_OBJECT \
            (SAFECAM_INTERFACE_OBJECT)NULL

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/
// The Safety Camera interface APIs
typedef struct safecam_plugin_interface_struct
{
    const DSI tDSI;

    const size_t tMaxVersionBitlen;

    size_t (*tMinimumOTABufferByteSize) (
        BOOLEAN bDBUpdatesEnabled
            );

    SAFECAM_INTERFACE_OBJECT (*hInit) (
        SAFETY_CAMERAS_SERVICE_OBJECT hSafeCamService,
        SMS_OBJECT hParent,
        RFD_UPDATE_VERSION tCurrentVersion
            );

    void (*vUnInit) (
        SAFECAM_INTERFACE_OBJECT hInterface
            );

    BOOLEAN (*bProcessMessage) (
        SAFECAM_INTERFACE_OBJECT hInterface,
        OSAL_BUFFER_HDL *phPayload
            );
} SAFECAM_PLUGIN_INTERFACE_STRUCT;

typedef struct safecam_mgr_interface_struct
{
    BOOLEAN (*bAddAlertLocation) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        SAFECAM_ALERT_LOCATIONS_ROW_STRUCT *psAlertLocation
            );

    BOOLEAN (*bAddSubLocation) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        SAFECAM_SUB_LOCATIONS_ROW_STRUCT *psSubLocation
            );

    BOOLEAN (*bModifyAlertLocation) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        SAFECAM_ALERT_LOCATIONS_ROW_STRUCT *psAlertLocation
            );

    BOOLEAN (*bModifySubLocation) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        SAFECAM_SUB_LOCATIONS_ROW_STRUCT *psSubLocation
            );

    BOOLEAN (*bDeleteAlertLocation) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        SAFECAM_ALERT_LOCATIONS_ROW_STRUCT *psAlertLocation
            );

    BOOLEAN (*bGetAlertLocationData) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        SAFECAM_ALERT_LOCATIONS_ROW_STRUCT *psAlertLocation
            );

    BOOLEAN (*bGetSubLocationData) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        SAFECAM_SUB_LOCATIONS_ROW_STRUCT *psSubLocation
            );

    BOOLEAN (*bUpdateAlertLocationRtree) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        SAFECAM_ALERT_LOCATIONS_ROW_STRUCT *psAlertLocation
            );

    BOOLEAN (*bAddAlertType) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        SAFECAM_ALERT_TYPES_ROW_STRUCT *psAlertType
            );

    BOOLEAN (*bDeleteAlertType) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        SAFECAM_ALERT_TYPES_ROW_STRUCT *psAlertType
            );

    BOOLEAN (*bIsAlertTypeExist) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        SAFECAM_ALERT_TYPES_ROW_STRUCT *psAlertType
            );

	BOOLEAN (*bDeleteSubLocation) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
		SAFECAM_SUB_LOCATIONS_ROW_STRUCT *psSubLocation
			);

    BOOLEAN (*bRefDBBank) (
        SAFETY_CAMERAS_SERVICE_OBJECT hSafeCamService,
        STRING_OBJECT *phInUseDB,
        STRING_OBJECT *phNextDB
            );

    BOOLEAN (*bDBUpdateBegin) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize
            );

    BOOLEAN (*bDBUpdateEnd) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        RFD_UPDATE_VERSION tUpdateVersion
            );

    void (*vTooOldUpdate) (
        SAFETY_CAMERAS_SERVICE_OBJECT hSafeCamService
            );

} SAFECAM_MGR_INTERFACE_STRUCT;

/****************************/
/** GLOBAL UNION TEMPLATES **/
/****************************/

/**********************/
/** GLOBAL VARIABLES **/
/**********************/

// Interface into the SafeCam plugins
extern const SAFECAM_PLUGIN_INTERFACE_STRUCT GsSafeCamIntf;

// Interface into the SafeCam Manager
extern const SAFECAM_MGR_INTERFACE_STRUCT GsSafeCamMgr;


/*******************/
/** GLOBAL MACROS **/
/*******************/

/***********************/
/** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

#endif /* SAFECAM_INTERFACE_H_ */

