/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:RFD_INTERFACE header file.
 *
 ******************************************************************************/

#ifndef RFD_INTERFACE_OBJ_H_
#define RFD_INTERFACE_OBJ_H_

#include "standard.h"

#include "rfd_config.h"
#include "rfd.h"
#include "rfd_linked_list.h"
#include "rfd_receiver.h"
#include "rfd_msg_collector.h"
#include "rfd_file_consumer.h"
#include "mfm_consumer.h"
#include "multifile_manager.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

// All clients connecting to the MFM must use
// this value for the fileReadyPollIntervalMillisec
// argument of MFM_CreateExt
#define RFD_INTERFACE_MFM_POLLRATE (1000)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// RFD Interface handle
typedef void * RFD_INTERFACE_OBJECT;
#define RFD_INTERFACE_INVALID_OBJECT (RFD_INTERFACE_OBJECT)NULL

typedef UN16 RFD_UPDATE_VERSION;

typedef UN32 RFD_PROGRESS_INDEX;
#define RFD_INVALID_PROGRESS_INDEX (RFD_PROGRESS_INDEX)UN32_MAX

typedef enum rfd_process_result_enum
{
    RFD_PROCESS_RESULT_COMPLETE,
    RFD_PROCESS_RESULT_INCOMPLETE,
    RFD_PROCESS_RESULT_ERROR,
    RFD_PROCESS_RESULT_INVALID

} RFD_PROCESS_RESULT_ENUM;

typedef enum rfd_process_status_enum
{
    RFD_PROCESS_STATUS_BEGIN,
    RFD_PROCESS_STATUS_CONTINUE,
    RFD_PROCESS_STATUS_STOP

} RFD_PROCESS_STATUS_ENUM;


typedef enum rfd_file_status_enum
{
    RFD_FILE_STATUS_INVALID = 0,
    RFD_FILE_STATUS_APPLICABLE,
    RFD_FILE_STATUS_NOT_NEEDED,
    RFD_FILE_STATUS_EXPIRED_DB
} RFD_FILE_STATUS_ENUM;

// *****************************************
// * Callback made when a new file is received
// *
// *    hConnection -- The RFD Connection where the new file was received
// *    pvCallbackArg -- The argument supplied when the connection was created.
// *****************************************
typedef RFD_PROCESS_RESULT_ENUM (*RFD_FILE_PROCESSOR_CALLBACK) (
    RFD_INTERFACE_OBJECT hConnection,
    RFD_PROCESS_STATUS_ENUM eProcessStatus,
    FILE *psRFDFile,
    RFD_UPDATE_VERSION tFileVersion,
    RFD_PROGRESS_INDEX tProgressIndex,
    void *pvCallbackArg
        );

typedef struct rfd_optional_callbacks_struct
{
    RFD_FILE_STATUS_ENUM (*eUpdateNeeded) (
        RFD_INTERFACE_OBJECT hConnection,
        const char *pcFileName,
        RFD_UPDATE_VERSION *ptFileVersion,
        size_t tVersionBitWidth,
        void *pvCallbackArg
            );

    void (*vReportExpiredDB) (
        RFD_INTERFACE_OBJECT hConnection,
        void *pvCallbackArg
            );

} RFD_OPTIONAL_CALLBACKS_STRUCT;

typedef struct rfd_lib_connection_struct
{
    // The ID for the RFD Client
    UN8 un8ClientId;

    // The RFD collector assigned to this client
    RFD_COLLECTOR_THREAD_DATA_HANDLE hCollector;

    // The RFD Consumer assigned to this client
    RFD_CONSUMER_THREAD_DATA_HANDLE hConsumer;

} RFD_LIB_CONNECTION_STRUCT;

// RFD interface event types
typedef enum rfd_interface_event_enum
{
    RFD_INTERFACE_EVENT_POLL_FILE = 0,
    RFD_INTERFACE_EVENT_PROCESS_PAYLOAD,
    RFD_INTERFACE_EVENT_PROCESS_FILE,
    RFD_INTERFACE_SHUTDOWN,

} RFD_INTERFACE_EVENT_ENUM;

// RFD file version comparison behavior control
typedef enum rfd_interface_baseline_check
{
    RFD_INTERFACE_BASELINE_CHECK_PERFORM = 0,
    RFD_INTERFACE_BASELINE_CHECK_SKIP

} RFD_INTERFACE_BASELINE_CHECK;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

RFD_INTERFACE_OBJECT RFD_INTERFACE_hConnect (
    UN8 un8ClientId,
    RFD_UPDATE_VERSION tCurrentVersion,
    size_t tVersionBitWidth,
    RFD_FILE_PROCESSOR_CALLBACK eProcessFile,
    RFD_OPTIONAL_CALLBACKS_STRUCT *psCallbacks,
    void *pvProcessFileArg
        );

void RFD_INTERFACE_vDisconnect (
    RFD_INTERFACE_OBJECT hConnection
        );

BOOLEAN RFD_INTERFACE_bAcquireRFDConnectionsForMFM (
    UN8 un8BaseClientId,
    MFM_RFD_CLIENT_STRUCT *pasConnections,
    size_t tNumConnections
        );

void RFD_INTERFACE_vReleaseRFDConnectionsForMFM (
    UN8 un8BaseClientId
        );

BOOLEAN RFD_INTERFACE_bProcessPayload (
    RFD_INTERFACE_OBJECT hConnection,
    OSAL_BUFFER_HDL hPayload
        );

BOOLEAN RFD_INTERFACE_bReportProgress (
    RFD_INTERFACE_OBJECT hConnection,
    RFD_PROGRESS_INDEX tCurrentProgress
        );

RFD_FILE_STATUS_ENUM RFD_INTERFACE_eCompareFileVersions (
    RFD_UPDATE_VERSION tBaseVersion,
    RFD_UPDATE_VERSION tCurrentVersion,
    RFD_UPDATE_VERSION tNewVersion,
    size_t tVersionBitWidth,
    RFD_INTERFACE_BASELINE_CHECK eCheckBaseline
        );

BOOL RFD_INTERFACE_bMFMReportTime (
    RFD_SXI_TIME_INFO_STRUCT *psSxiTimeInfo,
    void *pvUnused
        );


#endif /* RFD_INTERFACE_OBJ_H_ */
