/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:PRESET_BAND header file.
 *
 ******************************************************************************/

#include "sms_api.h"
#include "tag_obj.h"

#ifndef PRESET_BAND_OBJ_H_
#define PRESET_BAND_OBJ_H_

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/
#define PRESET_BAND_TAG "Band"

// These definitions are used to represent a BOOLEAN value in text form.
#define PRESET_BAND_TRUE_TEXT              "TRUE"
#define PRESET_BAND_FALSE_TEXT             "FALSE"

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

void PRESET_BAND_vDelete (
    PRESET_BAND_OBJECT hBand
        );

BOOLEAN PRESET_BAND_bRestorePresetBands(
    PRESETS_OBJECT hPresets
        );

void PRESET_BAND_vClearCurrentBand(
    TAG_OBJECT hTag
        );

SMSAPI_RETURN_CODE_ENUM PRESET_BAND_eSaveCurrentBand(
    PRESET_BAND_OBJECT hBand
        );

PRESET_BAND_OBJECT PRESET_BAND_hCreateFeaturedBand (
    PRESETS_OBJECT hPresets,
    size_t tCapacity,
    PRESET_BAND_PRIVATE_ATTRS_STRUCT *psAttrs,
    SERVICE_ID const *ptPresets,
    size_t tSIDCount
        );

FAVORITES_BAND_ID PRESET_BAND_eGetId (
    PRESET_BAND_OBJECT hBand
        );

FAVORITES_BAND_SEQUENCE PRESET_BAND_tGetSequence (
    PRESET_BAND_OBJECT hBand
        );

FAVORITES_BAND_PURPOSE_MASK PRESET_BAND_tGetPurpose (
    PRESET_BAND_OBJECT hBand
        );

FAVORITES_BAND_ORDER PRESET_BAND_eGetOrder (
    PRESET_BAND_OBJECT hBand
        );

BOOLEAN PRESET_BAND_bIsRemoved (
    PRESET_BAND_OBJECT hBand
        );

SMSAPI_RETURN_CODE_ENUM PRESET_BAND_eSetRemoved(
    PRESET_BAND_OBJECT hBand,
    size_t tRemoved
        );

void PRESET_BAND_vDestroy (
    PRESET_BAND_OBJECT hBand
        );

BOOLEAN PRESET_BAND_bUpdateSequence (
    PRESET_BAND_OBJECT hBand,
    FAVORITES_BAND_SEQUENCE tSequence
        );

BOOLEAN PRESET_BAND_bUpdateCapacity (
    PRESET_BAND_OBJECT hBand,
    size_t tCapacity
        );

BOOLEAN PRESET_BAND_bUpdate (
    PRESET_BAND_OBJECT hBand,
    FAVORITES_BAND_ID tId,
    FAVORITES_BAND_ORDER tOrder,
    FAVORITES_BAND_SEQUENCE tSequence,
    FAVORITES_BAND_PURPOSE_MASK tPurpose,
    char const * pacTitleShort,
    char const * pacTitleLong,
    char const * pacTitleVerbose,
    char const * pacDescription,
    SERVICE_ID const * ptArrangement,
    size_t tSIDCount
        );

SMSAPI_RETURN_CODE_ENUM PRESET_BAND_eSetPresets(
    PRESET_BAND_OBJECT hBand,
    SERVICE_ID const *ptArrangement,
    size_t tSIDCount
        );

BOOLEAN PRESET_BAND_bRemoveBandTagIterator(
    TAG_OBJECT hTag,
    void *pvArg
        );

#endif /* PRESET_BAND_OBJ_H_ */

