/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This file defines the constants used when utilizing the phonetics
 * database files
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef PHONETICS_DB_CONSTANTS_H_
#define PHONETICS_DB_CONSTANTS_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

/* Database File Name */
#define PHONETICS_DATABASE_FOLDER "phonetics"
#define PHONETICS_REF_DATABASE_FILENAME "phonetics_ref.db"
#define PHONETICS_PERSIST_DATABASE_FILENAME "phonetics.db"

#define PHONETICS_MAX_LEAGUES (8)
#define PHONETICS_MAX_LANGUAGES (3)

/* Database Version */
#define PHONETICS_DATABASE_FILE_VERSION (0)

/* Database Table Names */
#define VERSION_TABLE_NAME "version"
#define CHANNEL_TABLE_NAME "channel"
#define CATEGORY_TABLE_NAME "category"
#define MARKET_TABLE_NAME "market"
#define TEAM_TABLE_NAME "team"
#define LEAGUE_TABLE_NAME "league"

/* Database Commands / Queries */

// Version Table

// Select all from version
#define PHONETICS_SELECT_ALL_DB_VERSION \
    "select * from "VERSION_TABLE_NAME";"

// Create a new version table
#define PHONETICS_CREATE_VERSION_TABLE     \
    "create table "VERSION_TABLE_NAME" ( " \
    "type int, value int,"         \
    "primary key (type) );"
#define PHONETICS_CREATE_VERSION_TABLE_LEN (80)

// Update version Table
#define PHONETICS_INSERT_UPDATE_VERSION_ROW \
    "insert or replace into "VERSION_TABLE_NAME" " \
    "(type, value) values(%2u, %5u);"
#define PHONETICS_INSERT_UPDATE_LEN (72)

#define PHONETICS_SQL_COMMAND_MAX_LEN (72)

// Phonetics Tables

// Select all channels
#define PHONETICS_SELECT_CHANNELS \
    "select * from "CHANNEL_TABLE_NAME" order by ID asc;"

// Select all categories
#define PHONETICS_SELECT_CATEGORIES \
    "select * from "CATEGORY_TABLE_NAME" order by ID asc;"

// Select all markets
#define PHONETICS_SELECT_MARKETS \
    "select * from "MARKET_TABLE_NAME" order by ID asc;"

// Select all teams
#define PHONETICS_SELECT_TEAMS \
    "select * from "TEAM_TABLE_NAME" order by teamID, league0, league1, league2 asc;"

// Select all leagues
#define PHONETICS_SELECT_LEAGUES \
    "select * from "LEAGUE_TABLE_NAME" order by ID asc;"

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef enum phonetics_db_version_types_enum {
    PHONETICS_DB_VERSION_TYPE_DB_SCHEMA = 0,

    PHONETICS_DB_VERSION_TYPE_CHAN_DEF,
    PHONETICS_DB_VERSION_TYPE_CHAN_CONTENT,

    PHONETICS_DB_VERSION_TYPE_CAT_DEF,
    PHONETICS_DB_VERSION_TYPE_CAT_CONTENT,

    PHONETICS_DB_VERSION_TYPE_MARKET_DEF,
    PHONETICS_DB_VERSION_TYPE_MARKET_CONTENT,

    PHONETICS_DB_VERSION_TYPE_TEAM_DEF,
    PHONETICS_DB_VERSION_TYPE_TEAM_CONTENT,

    PHONETICS_DB_VERSION_TYPE_LEAGUE_DEF,
    PHONETICS_DB_VERSION_TYPE_LEAGUE_CONTENT,

    PHONETICS_DB_VERSION_MAX_TYPES

} PHONETICS_DB_VERSION_TYPES_ENUM;

// Enumeration specifying all the available fields
// in the version table
typedef enum phonetics_db_version_fields_enum {
    PHONETICS_DB_VERSION_TYPE = 0,
    PHONETICS_DB_VERSION_VER,
    PHONETICS_DB_VERSION_MAX_FIELDS

} PHONETICS_DB_VERSION_FIELDS_ENUM;

// Enumeration specifying all the available fields
// in the single id phonetics tables (all tables
// except the teams table)
typedef enum phonetics_db_base_phonetic_fields_enum {

    PHONETICS_DB_BASE_PHONETIC_ID = 0,
    //PHONETICS_DB_BASE_PHONETIC_VER, We don't need this
    PHONETICS_DB_BASE_PHONETICS_ENG,
    PHONETICS_DB_BASE_PHONETICS_ESP,
    PHONETICS_DB_BASE_PHONETICS_FR,
    PHONETICS_DB_BASE_PHONETIC_MAX_FIELDS

} PHONETICS_DB_BASE_PHONETIC_FIELDS_ENUM;

// Enumeration specifying all the available fields
// in the team phonetics table
typedef enum phonetics_db_team_phonetic_fields_enum {

    PHONETICS_DB_TEAM_PHONETIC_ID = 0,
    PHONETICS_DB_TEAM_PHONETIC_NUM_LEAGUES,
    PHONETICS_DB_TEAM_LEAGUE0,
    PHONETICS_DB_TEAM_LEAGUE1,
    PHONETICS_DB_TEAM_LEAGUE2,
    //PHONETICS_DB_TEAM_PHONETIC_VER
    PHONETICS_DB_TEAM_PHONETIC_ENG,
    PHONETICS_DB_TEAM_PHONETIC_ESP,
    PHONETICS_DB_TEAM_PHONETIC_FR,
    PHONETICS_DB_TEAM_PHONETIC_MAX_FIELDS

} PHONETICS_DB_TEAM_PHONETIC_FIELDS_ENUM;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

// Structure which specifies all attributes
// of a single database version row that is
// available within the phonetics database
typedef struct phonetics_version_row_struct
{
    PHONETICS_DB_VERSION_TYPES_ENUM eType; // The type of version data
    N32 n32Version;                        // The version of that data

} PHONETICS_VERSION_ROW_STRUCT;

// Structure which specifies all attributes
// of a phonetics entry which identify id
typedef struct phonetics_phonetic_id_struct
{
    // Basic ID used by all types
    UN32 un32Id;

    // Team specific attributes
    UN8 un8NumLeagues;
    UN16 aun16Leagues[PHONETICS_MAX_LEAGUES];

} PHONETICS_PHONETIC_ID_STRUCT;

// Structure which specifies all attributes
// of a single database row that is
// available within the phonetics database
typedef struct phonetics_phonetic_row_struct
{
    // Identifiers for this row
    PHONETICS_PHONETIC_ID_STRUCT sID;

    // Phonetics information
    const char *pacPhonetics[PHONETICS_MAX_LANGUAGES];

    // We don't care about the last version that
    // updated this entry -- we always output everything
    // in the phonetics table that is different from our baseline
    // UN32 un32EntryVersion;

} PHONETICS_PHONETIC_ROW_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

#endif // PHONETICS_DB_CONSTANTS_H_
