/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This file defines the interface used for service-specific movies parsers
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef MOVIES_INTERFACE_H_
#define MOVIES_INTERFACE_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "sms_api.h"
#include "sms_obj.h"

#include "theater_times_obj.h"
#include "movies_mgr_obj.h"
#include "movies_db_constants.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Handle to the movies interface object
typedef void * MOVIES_INTERFACE_OBJECT;
#define MOVIES_INTERFACE_INVALID_OBJECT ((MOVIES_INTERFACE_OBJECT)NULL)

typedef enum movie_message_type_enum
{
    MOVIE_MESSAGE_TYPE_DESCRIPTION = 0,
    MOVIE_MESSAGE_TYPE_TIMES = 1,
    MOVIE_MESSAGE_TYPE_THEATER = 3,
    MOVIE_MESSAGE_TYPE_UNKNOWN,
    MOVIE_MESSAGE_TYPE_RFD,
    MOVIE_MESSAGE_TYPE_IGNORE,
    MOVIE_MESSAGE_TYPE_ERROR

} MOVIE_MESSAGE_TYPE_ENUM;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

typedef struct movies_plugin_interface_struct
{
    const DSI tDSI;

    const size_t tMaxVersionBitlen;

    size_t (*tMinimumOTABufferByteSize) (
        BOOLEAN bDBUpdatesEnabled
            );

    // Returns a handle to an object that contains
    // broadcast specific data used for handling the movies
    // data stream
    MOVIES_INTERFACE_OBJECT (*hInit) (
        MOVIES_SERVICE_OBJECT hMoviesService,
        SMS_OBJECT hParent,
        BOOLEAN bDBUpdatesEnabled,
        UN8 un8CurDBVersion
            );

    // Interface function that parses the header from the payload
    // to determine the type of movie message
    MOVIE_MESSAGE_TYPE_ENUM (*eParseMessageHeader) (
        MOVIES_INTERFACE_OBJECT hInterfaceObj,
        OSAL_BUFFER_HDL hPayload,
        MOVIE_VERSION *ptVersion
            );

    MOVIE_OBJECT (*hParseDescription) (
        MOVIES_INTERFACE_OBJECT hInterfaceObj,
        SMS_OBJECT hMovieParent,
        OSAL_BUFFER_HDL hPayload,
        BOOLEAN *pbMoreData
            );

    BOOLEAN (*bMarkDescriptionPayloadAsParsed) (
        MOVIES_INTERFACE_OBJECT hInterfaceObj,
        BOOLEAN *pbCarouselComplete
            );

    BOOLEAN (*bResetDescriptionPayloadTracking) (
        MOVIES_INTERFACE_OBJECT hInterfaceObj
            );

    BOOLEAN (*bParseTimes) (
        MOVIES_INTERFACE_OBJECT hInterfaceObj,
        SMS_OBJECT hTimesParent,
        OSAL_BUFFER_HDL hPayload,
        THEATER_TIMES_OBJECT *phTheaterTimes,
        THEATER_ID *ptTHID,
        BOOLEAN *pbMoreData
            );

    BOOLEAN (*bMarkTimesPayloadAsParsed) (
        MOVIES_INTERFACE_OBJECT hInterfaceObj,
        BOOLEAN *pbCarouselComplete
            );

    BOOLEAN (*bResetTimesPayloadTracking) (
        MOVIES_INTERFACE_OBJECT hInterfaceObj
            );

    void (*vUninit) (
        MOVIES_INTERFACE_OBJECT hInterfaceObj
            );

} MOVIES_PLUGIN_INTERFACE_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

// Interface into the Movies plug-in
extern const MOVIES_PLUGIN_INTERFACE_STRUCT GsMoviesIntf;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

#endif /* MOVIES_INTERFACE_H_ */
