/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:MOVIE header file.
 *
 ******************************************************************************/

#ifndef MOVIE_OBJ_H_
#define MOVIE_OBJ_H_

#include "sms_api.h"
#include "movies_db_constants.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
MOVIE_OBJECT MOVIE_hCreate (
    SMS_OBJECT hParent,
    MOVIE_ID tID,
    MOVIE_MULTI_LANG_FIELD_STRUCT *psName,
    UN8 un8RunTime,
    STRING_OBJECT hActors,
    MOVIE_MULTI_LANG_FIELD_STRUCT *psSynopsis,
    size_t tNumRatings,
    MOVIE_RATING_STRUCT *pasRatings
        );

MOVIE_OBJECT MOVIE_hCreateDummy (
    SMS_OBJECT hParent
        );

BOOLEAN MOVIE_bUpdateDummyID (
    MOVIE_OBJECT hDummy,
    MOVIE_ID tID
        );

BOOLEAN MOVIE_bGetMultiValueFields (
    MOVIE_OBJECT hMovie,
    MOVIE_MULTI_LANG_FIELD_STRUCT **ppsName,
    MOVIE_MULTI_LANG_FIELD_STRUCT **ppsSynopsis,
    size_t *ptNumRatings,
    MOVIE_RATING_STRUCT *pasRatings
        );

void MOVIE_vSetException (
    MOVIE_OBJECT hMovie,
    MOVIE_RATING_SYSTEM_ENUM eRatingSytem,
    MOVIE_RATING_ENUM eRating,
    STRING_OBJECT hRatingText
        );

void MOVIE_vClearException (
    MOVIE_OBJECT hMovie
        );

void MOVIE_vDestroy (
    MOVIE_OBJECT hMovie
        );

N16 MOVIE_n16CompareID (
    MOVIE_OBJECT hMovie1,
    MOVIE_OBJECT hMovie2
        );

#endif /* MOVIE_OBJ_H_ */
