/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SMS Task header file.
 *
 ******************************************************************************/

#ifndef MODULE_OBJ_H_
#define MODULE_OBJ_H_

#include "standard.h"

#include "sti_api.h"
#include "sms_api.h"
#include "sms_event_types.h"
#include "sms_event.h"
#include "tag_obj.h"
#include "dataservice_mgr_obj.h"
#include "module_version_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef BOOLEAN (*DISPATCH_DECODER_EVENT_CALLBACK)(
    DECODER_OBJECT hDecoder,
    SMS_EVENT_TYPE_ENUM eType,
    const void *pvEventArg
        );

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN MODULE_bRelease (
    MODULE_OBJECT hModule,
    SMS_OBJECT_RELEASE_INITIATOR_ENUM eInitiator
        );

MODULE_STATE_ENUM MODULE_eState (
    MODULE_OBJECT hModule
        );

BOOLEAN MODULE_bAssociate (
    MODULE_OBJECT hModule,
    SRM_OBJECT hSRM,
    const char *pacName,
    FILE *psDevice
        );

BOOLEAN MODULE_bUnassociate (
    MODULE_OBJECT hModule
        );

BOOLEAN MODULE_bAddDecoder (
    MODULE_OBJECT hModule,
    DECODER_OBJECT hDecoder
        );

BOOLEAN MODULE_bRemoveDecoder (
    MODULE_OBJECT hModule,
    DECODER_OBJECT hDecoder
        );

SMSAPI_RETURN_CODE_ENUM MODULE_eModifyEngineeringData (
    MODULE_OBJECT hModule,
    DECODER_OBJECT hDecoder,
    SMSAPI_MODIFY_EVENT_MASK_ENUM eModification
        );

BOOLEAN MODULE_bSetError (
    MODULE_OBJECT hModule,
    MODULE_ERROR_CODE_ENUM eErrorCode
        );

SMS_EVENT_HDL MODULE_hAllocateEvent(
    MODULE_OBJECT hModule,
    SMS_EVENT_TYPE_ENUM eEvent,
    EVENT_OPTIONS_TYPE tOptions,
    SMS_EVENT_DATA_UNION ** ppuEventData
        );

BOOLEAN MODULE_bDispatchDecoderEvent (
    MODULE_OBJECT hModule,
    SMS_EVENT_TYPE_ENUM eType,
    void *pvEventArg,
    DISPATCH_DECODER_EVENT_CALLBACK bDispatch,
    BOOLEAN bOnlyIfEngineeringDataRequested
        );

DECODER_OBJECT MODULE_hDecoder (
    MODULE_OBJECT hModule,
    const char *pacDecoderName
        );

const char *MODULE_pacName (
    MODULE_OBJECT hModule
        );

BOOLEAN MODULE_bRadioReady (
    MODULE_OBJECT hModule,
    STI_HDL hSTI
        );

BOOLEAN MODULE_bRadioReleased (
    MODULE_OBJECT hModule
        );

BOOLEAN MODULE_bSetRadioSpecificData (
    MODULE_OBJECT hModule,
    RADIO_PRIVATE_DATA_OBJECT hData
        );

RADIO_PRIVATE_DATA_OBJECT MODULE_hGetRadioSpecificData (
    MODULE_OBJECT hModule
        );

TAG_OBJECT MODULE_hGetTag(
    MODULE_OBJECT hModule
        );

BOOLEAN MODULE_bReset (
    MODULE_OBJECT hModule
        );

BOOLEAN MODULE_bResetDecoder (
    MODULE_OBJECT hModule,
    DECODER_OBJECT hDecoder
        );

MODULE_ERROR_CODE_ENUM MODULE_eInitialize (
    MODULE_OBJECT hModule
        );

void MODULE_vUpdateSubStatus(
    MODULE_OBJECT hModule
        );

MODULE_VERSION_OBJECT MODULE_hModuleVersion (
    MODULE_OBJECT hModule
        );

void MODULE_vUpdateIRSupport(
    MODULE_OBJECT hModule,
    BOOLEAN bValue
        );

void MODULE_vUpdateAdvancedIRSupport(
    MODULE_OBJECT hModule,
    BOOLEAN bValue
        );

BOOLEAN MODULE_bIsIRSupported(
    MODULE_OBJECT hModule
        );

void MODULE_vUpdateProgress(
    MODULE_OBJECT hModule,
    UN8 un8UpdateProgress,
    SMSAPI_RETURN_CODE_ENUM eFWUpdateFileLoadError
        );

BOOLEAN MODULE_bSetPkgData (
    MODULE_OBJECT hModule,
    size_t tNumBytes,
    UN8 const *pun8Data
        );

BOOLEAN MODULE_bSetEventData (
    MODULE_OBJECT hModule,
    MODULE_EVENT_DATA_STRUCT *psData
        );

BOOLEAN MODULE_bOverlaySupported (
    MODULE_OBJECT hModule
        );

BOOLEAN MODULE_bIsAdvancedIrSupported (
    MODULE_OBJECT hModule
        );

BOOLEAN MODULE_bSetTime (
    MODULE_OBJECT hModule,
    TIME_T tTod,
    UN32 un32AtSeconds,
    UN16 un16AtMsecs
        );

#endif /* MODULE_OBJ_H */
