/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:LOCID header file.
 *
 ******************************************************************************/

#ifndef LOCID_OBJ_H_
#define LOCID_OBJ_H_

#include "sms_api.h"
#include "traffic_locid_obj.h"


  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef union locid_union
{
    // LOCID's
    // Any LOCID structure can be one of the following;
    TRAFFIC_LOCID_OBJECT_STRUCT sTrafficLocID;
} LOCID_UNION;

#define LOCID_INVALID_UNION ((LOCID_UNION*)NULL)

typedef struct locid_interface_struct
{
    const void * (*hDuplicate) (
        const void *psLOCID
            );

    N16 (*n16Compare) (
        const void *psLOCID1,
        const void *psLOCID2
            );

    N32 (*n32FWrite) (
        const void *psLOCID,
        FILE *psFile
            );

    N32 (*n32FPrintf) (
        const void *psLOCID,
        FILE *psFile
            );

} LOCID_INTERFACE_STRUCT;


  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/
LOCID_OBJECT LOCID_hCreate (
    LOC_ID tID,
    LOCID_TYPE_ENUM       eType,
    const LOCID_INTERFACE_STRUCT *psInterface
        );

LOCID_UNION *LOCID_puSubClassData (
    LOCID_OBJECT hLocID
        );

N32 LOCID_n32FWrite (
    LOCID_OBJECT hLocID,
    FILE *psFile
        );

#endif /* LOCID_OBJ_H */
