/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:LOCATION header file.
 *
 ******************************************************************************/

#ifndef LOCATION_OBJ_H_
#define LOCATION_OBJ_H_

#include "sms_api.h"
#include "tag_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

// This is the binpoint all
// services should use when
// creating fixed point values
// for location-based services.
#define LOCATION_BINPOINT (22)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef N16 STATE_ID;
#define STATE_INVALID_ID  ((STATE_ID)N16_MIN)
#define STATE_ID_MIN      ((STATE_ID)1)
#define STATE_ID_MAX      ((STATE_ID)96)

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

// Structure containing all string attributes
// which may change over time
typedef struct location_attribute_struct
{
    // The description for this LOCATION as a STRING_OBJECT
    STRING_OBJECT   hDescription;

    // The street address (just the number) for this LOCATION as a STRING_OBJECT
    STRING_OBJECT   hStreetNum;

    // The street name for this LOCATION as a STRING_OBJECT
    STRING_OBJECT   hStreetName;

    // The city name for this LOCATION as a STRING_OBJECT
    STRING_OBJECT   hCity;

    // The state abbreviation for this LOCATION as a STRING_OBJECT
    STRING_OBJECT   hState;

    // The Zip Code for this LOCATION as a STRING_OBJECT
    STRING_OBJECT   hZipCode;

    // The phone number for this LOCATION as a STRING_OBJECT
    STRING_OBJECT   hPhone;

} LOCATION_ATTRIBUTE_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
LOCATION_OBJECT LOCATION_hCreate (
    SMS_OBJECT      hOwner,
    LOCID_OBJECT    hLocID,
    N32 n32Lat,
    UN8 un8LatBits,
    N32 n32Lon,
    UN8 un8LonBits,
    DISTANCE_OBJECT hRadius,
    LOCATION_ATTRIBUTE_STRUCT *psDescriptiveAttrs,
    BOOLEAN bPerformDeepCopy
        );

LOCATION_OBJECT LOCATION_hCreateForDeviceArea (
    DISTANCE_OBJECT hRadius
        );

LOCATION_OBJECT LOCATION_hDuplicate (
    SMS_OBJECT     hOwner,
    LOCATION_OBJECT hLocation
        );

BOOLEAN LOCATION_bUpdateCoordinates (
    LOCATION_OBJECT  hLocation,
    N32 n32Lat,
    UN8 un8LatBits,
    N32 n32Lon,
    UN8 un8LonBits
        );

BOOLEAN LOCATION_bUpdateCoordinatesByFixed (
    LOCATION_OBJECT hLocation,
    OSAL_FIXED_OBJECT hLat,
    OSAL_FIXED_OBJECT hLon
        );

BOOLEAN LOCATION_bUpdateRadius (
    LOCATION_OBJECT hLocation,
    DISTANCE_OBJECT hRadius,
    BOOLEAN bPerformDeepCopy
        );

BOOLEAN LOCATION_bCalcDestCoordinatesFromLocation (
    LOCATION_OBJECT hLocationFrom,
    DISTANCE_OBJECT hDistance,
    OSAL_FIXED_OBJECT hBrearing,
    OSAL_FIXED_OBJECT hLatTo,
    OSAL_FIXED_OBJECT hLonTo
        );

BOOLEAN LOCATION_bContains (
    LOCATION_OBJECT hContainer,
    LOCATION_OBJECT hContained,
    DISTANCE_OBJECT hThreshold
        );

BOOLEAN LOCATION_bTopRight (
    LOCATION_OBJECT hLocation,
    OSAL_FIXED_OBJECT hTopRightLat,
    OSAL_FIXED_OBJECT hTopRightLon
        );

BOOLEAN LOCATION_bBottomLeft (
    LOCATION_OBJECT hLocation,
    OSAL_FIXED_OBJECT hBottomLeftLat,
    OSAL_FIXED_OBJECT hBottomLeftLon
        );

BOOLEAN LOCATION_bUpdateLocID (
    LOCATION_OBJECT hLocation,
    LOCID_OBJECT hLocID,
    BOOLEAN bPerformDeepCopy
        );

BOOLEAN LOCATION_bUpdateDescriptiveAttributes (
    LOCATION_OBJECT hLocation,
    LOCATION_ATTRIBUTE_STRUCT *psAttributes,
    BOOLEAN bOverwriteAllFields,
    BOOLEAN bPerformDeepCopy
        );

BOOLEAN LOCATION_bCompare (
    LOCATION_OBJECT hLocation1,
    LOCATION_OBJECT hLocation2
        );

STRING_OBJECT LOCATION_hStateAbbrvForID (
    STATE_ID tStateID
        );

STATE_ID LOCATION_tStateIDForAbbrv (
    STRING_OBJECT hStateAbbrevName
        );

DSRL_TARGET_OBJECT LOCATION_hCreateTargetFromTag (
    TAG_OBJECT hTag
        );

TAG_OBJECT LOCATION_hGetTargetTag (
    TAG_OBJECT hParentTag,
    DSRL_TARGET_OBJECT hTarget
        );

BOOLEAN LOCATION_bIsDevicePosition(
    LOCATION_OBJECT hLocation
        );

BOOLEAN LOCATION_bLineClip (
    OSAL_FIXED_OBJECT hX0,
    OSAL_FIXED_OBJECT hY0,
    OSAL_FIXED_OBJECT hX1,
    OSAL_FIXED_OBJECT hY1,
    LOCATION_OBJECT  hLocation
        );

BOOLEAN LOCATION_bRayCross (
    OSAL_FIXED_OBJECT hX0,
    OSAL_FIXED_OBJECT hY0,
    OSAL_FIXED_OBJECT hX1,
    OSAL_FIXED_OBJECT hY1,
    LOCATION_OBJECT  hLocation
        );

BOOLEAN LOCATION_bCoordinatesWithinRectangle (
    LOCATION_OBJECT hLocation,
    OSAL_FIXED_OBJECT hLat,
    OSAL_FIXED_OBJECT hLon
        );

#endif /* LOCATION_OBJ_H */
