/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
* DESCRIPTION
*
* This is the Object:LEAGUE header file.
*
******************************************************************************/

#ifndef LEAGUE_OBJ_H_
#define LEAGUE_OBJ_H_

#include <stddef.h>

#include "standard.h"
#include "osal.h"
#include "cid_obj.h"
#include "sms_api.h"

/**********************/
/** GLOBAL CONSTANTS **/
/**********************/

#define LEAGUE_INVALID_VERSION (-1)

/*********************/
/** GLOBAL TYPEDEFS **/
/*********************/

// Basic league information structure
typedef struct league_struct
{
    // Sport enumeration (type)
    SPORTS_ENUM eSport;

    // League enumeration (type)
    LEAGUE_ENUM eLeague;

    // League abbreviation
    STRING_OBJECT hAbbreviation;

    // League textual name
    STRING_OBJECT hName;

    // SportsFlash Enabled value
    BOOLEAN bSportsFlashEnabled;

    // SportsFlash Tiers
    UN8 un8SportsFlashTiers;

    // Version
    N32 n32Version;

} LEAGUE_STRUCT;

/*****************************/
/** GLOBAL STRUCT TEMPLATES **/
/*****************************/

/****************************/
/** GLOBAL UNION TEMPLATES **/
/****************************/

/**********************/
/** GLOBAL VARIABLES **/
/**********************/

/*******************/
/** GLOBAL MACROS **/
/*******************/

/***********************/
/** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN LEAGUE_bInitialize (
    SMS_OBJECT hParent
        );

void LEAGUE_vUnInitialize ( void );

BOOLEAN LEAGUE_bSetMasterLockableObject (
    SMS_OBJECT hObject
        );

LEAGUE_OBJECT LEAGUE_hAdd (
    SPORTS_ENUM eSport,
    LEAGUE_ENUM eLeague,
    CID_OBJECT hLeagueId,
    N32 n32Version,
    char const *pacName,
    char const *pacAbbrev,
    BOOLEAN bSportsFlashEnabled,
    UN8 un8SportsFlashTiers
        );

BOOLEAN LEAGUE_bAddTeam (
    LEAGUE_OBJECT hLeague,
    TEAM_OBJECT hTeam
        );

BOOLEAN LEAGUE_bRemoveTeam(
    LEAGUE_OBJECT hLeague, 
    TEAM_OBJECT hTeam
        );

LEAGUE_OBJECT LEAGUE_hFind (
    CID_OBJECT hLeagueId,
    BOOLEAN bCreateIfNotExists
        );

TEAM_OBJECT LEAGUE_hFindTeam (
    LEAGUE_OBJECT hLeague,
    CID_OBJECT hTeamId,
    BOOLEAN bCreateIfNotExists
        );

BOOLEAN LEAGUE_bIterateTeams (
    LEAGUE_OBJECT hLeague,
    BOOLEAN bLockMaster,
    TEAM_CONTENT_ITERATOR_CALLBACK bContentIteratorCallback,
    void *pvContentIteratorCallbackArg
        );

BOOLEAN LEAGUE_bIterateContent (
    LEAGUE_CONTENT_ITERATOR_CALLBACK bContentIteratorCallback,
    void *pvContentIteratorCallbackArg
        );

BOOLEAN LEAGUE_bLoad (
    CID_ENUM eType
        );

UN32 LEAGUE_un32Count ( 
    N32 n32Version, 
    UN32 *pun32Total, 
    UN32 un32Expected
        );

BOOLEAN LEAGUE_bSave (
    N32 n32Version
        );

CID_OBJECT LEAGUE_hCreateCid(
    CID_POOL hCidPool,
    const void *pvSrcObjectData
        );

BOOLEAN LEAGUE_bPruneTeams(
    LEAGUE_OBJECT hLeague, 
    N32 n32Version
        );

UN8 LEAGUE_un8SportsFlashTiers(
    LEAGUE_OBJECT hLeague
        );

#endif /* LEAGUE_OBJ_H */
