/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object: PROGRAM header file.
 *
 ******************************************************************************/

#ifndef EPROGRAM_OBJ_H_
#define EPROGRAM_OBJ_H_

#include "standard.h"

#include "epg_topic_obj.h"
#include "sms_api.h"
#include "epg_interface.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct epg_topics_list_struct
{
    UN8 un8NumTopics; // Number of topics in the list
    OSAL_OBJECT_HDL hTopicsList; // List of pointers to EPG_TOPIC_STRUCT//TODO: Replace with array?

} EPG_TOPICS_LIST_STRUCT;

typedef struct eprog_event_struct
{
    PROGRAM_DAY_ID tSchSeg;
    PROGRAM_DAY_ID tSchSegProgramDescription;

    SERVICE_ID tServiceId;

    SERIES_ID tSeriesId;
    PROGRAM_ID tProgramId;
    PROGRAM_FLAGS tPFlags; // bit mask - featured/highlited/live/new
    EPG_PROGRAM_RECORDING_OPTION_ENUM eRecordingOption;

    TIME_T tStartTime; // Seconds
    TIME_T tEndTime; // Seconds

    UN32 un32PNameShortIdx; // index to get handle to Short Program name
    UN32 un32PNameLongIdx; // index to get handle to Long Program name
    UN32 un32SeriesDescIdx; // index to get handle to Series Description
    UN32 un32ProgramDescIdx; // index to get  handle to Program Description

    UN16 un16OrigDate; // Day (epoch) when program was originally aired (usage is not clear)

    EPG_TOPICS_LIST hEpgTopics; // Handle to EPG_TOPICS_LIST_STRUCT

    // Handle to parent EPG channel object
    SMS_OBJECT hEpgChannel;

} PROG_EVENT_STRUCT;

typedef struct epg_channel_object_struct
{
    SERVICE_ID tServiceId;
    OSAL_OBJECT_HDL hEpgChannelEvents;  // List of PROG_EVENT_STRUCT
    OSAL_OBJECT_HDL hUniquePrograms;    // Unique linear list of PROG_EVENT_STRUCT
    EPG_SERVICE_OBJECT hEpgService;

} EPG_CHANNEL_OBJECT_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

/* ------------------- PROGRAM object related functions -------------------- */

PROG_EVENT_STRUCT *EPG_PROGRAM_psCreate (
        SMS_OBJECT hEpgChannel
            );

PROG_EVENT_STRUCT *EPG_PROGRAM_psDuplicate (
        PROG_EVENT_STRUCT *psProgramEvent,
        SMS_OBJECT hEpgChannel,
        TIME_T tNewStartTime
            );

void EPG_PROGRAM_vDestroy (
        PROG_EVENT_STRUCT *psProgramEvent
            );

BOOLEAN EPG_PROGRAM_bAddTopic (
        PROG_EVENT_STRUCT *psProgramEvent,
        EPG_TOPIC_STRUCT *psTopic
            );

N16 EPG_PROGRAM_n16CompareEpgEventAndStartTime (
        PROG_EVENT_STRUCT *psProgEvent,
        TIME_T *ptStartTime
            );

N16 EPG_PROGRAM_n16CompareEpgEventAndEndTime (
        PROG_EVENT_STRUCT *psProgEvent,
        TIME_T *ptEndTime
            );

N16 EPG_PROGRAM_n16CompareEpgEventsByStartTime (
        PROG_EVENT_STRUCT *psProgEvent1,
        PROG_EVENT_STRUCT *psProgEvent2
            );

N16 EPG_PROGRAM_n16CompareEpgEventsById (
        PROG_EVENT_STRUCT *psProgEvent1,
        PROG_EVENT_STRUCT *psProgEvent2
            );

N16 EPG_PROGRAM_n16CompareEpgEventAndSeriesId (
        PROG_EVENT_STRUCT *psProgEvent,
        SERIES_ID *ptSeriesId
            );

/* ------------------- CHANNEL object related functions -------------------- */

EPG_CHANNEL_OBJECT_STRUCT *EPG_CHANNEL_psCreate (
        SERVICE_ID tServiceId,
        SMS_OBJECT hParent
            );

void EPG_CHANNEL_vDestroy (
        EPG_CHANNEL_OBJECT_STRUCT *psChannel
            );

UN32 EPG_CHANNEL_un32GetShowsCount (
        EPG_CHANNEL_OBJECT_STRUCT *psChannel
            );

BOOLEAN EPG_CHANNEL_bAddProgramEventToEpgChannel (
        EPG_CHANNEL_OBJECT_STRUCT *psChannel,
        PROG_EVENT_STRUCT *psProgramEvent
            );

BOOLEAN EPG_CHANNEL_bAddProgramCopy (
        EPG_CHANNEL_OBJECT_STRUCT *psChannel,
        PROG_EVENT_STRUCT *psProgramEvent,
        TIME_T tNewStartTime
            );

N16 EPG_CHANNEL_n16CompareEpgChannelAndSid (
        EPG_CHANNEL_OBJECT_STRUCT *psEpgChannel,
        SERVICE_ID *ptServiceId
            );

N16 EPG_CHANNEL_n16CompareEpgChannelsBySid (
        EPG_CHANNEL_OBJECT_STRUCT *psChannel1,
        EPG_CHANNEL_OBJECT_STRUCT *psChannel2
            );

/* ------------------- TOPICS_LIST object related functions ---------------- */

EPG_TOPICS_LIST_STRUCT *EPG_TOPICS_LIST_psCreate (
        SMS_OBJECT hParent
            );

EPG_TOPICS_LIST_STRUCT *EPG_TOPICS_LIST_psDuplicate (
        EPG_TOPICS_LIST_STRUCT *psTopicsList,
        SMS_OBJECT hParent
            );

void EPG_TOPICS_LIST_vDestroy (
        EPG_TOPICS_LIST_STRUCT *psTopicsList
            );

BOOLEAN EPG_TOPICS_LIST_bAddTopic (
        EPG_TOPIC_STRUCT *psTopic,
        EPG_TOPICS_LIST_STRUCT *psTopicsList
            );

#endif /* EPROGRAM_OBJ_H_ */
