/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:EPG_MGR header file.
 *
 ******************************************************************************/

#ifndef EPG_MGR_OBJ_H_
#define EPG_MGR_OBJ_H_

#include "osal.h"
#include "sms_api.h"
#include "sms_event.h"

#include "dataservice_base.h"
#include "dataservice_mgr_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef enum epg_fw_event_enum
{
    EPG_FW_EVENT_LOAD_INITIAL_SCHEDULE

} EPG_FW_EVENT_ENUM;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN EPG_MGR_bLoadString (
        EPG_SERVICE_OBJECT hEpgService,
        UN8 un8SegNum,
        UN32 un32StringIndex,
        STRING_OBJECT hResultString
            );

void EPG_MGR_vDecoderEventHandler (
        DECODER_OBJECT hDecoder,
        SMS_EVENT_EPG_STRUCT const *psEpg
            );

#endif /* EPG_MGR_OBJ_H_ */
