/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:CHANNEL_ART header file.
 *
 ******************************************************************************/

#ifndef ENGINEERING_DATA_OBJ_H_
#define ENGINEERING_DATA_OBJ_H_

#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct engineering_data_object * ENGINEERING_DATA_OBJECT;
#define ENGINEERING_DATA_INVALID_OBJECT (ENGINEERING_DATA_OBJECT)NULL

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/
typedef struct detailed_signal_quality_struct
{
    DETAILED_SIGNAL_STRENGTH_ENUM eSignalStrength;
    UN8 un8TunerStatus;
    UN8 un8ENSALockStatus;
    UN8 un8ENSBLockStatus;
    UN16 un16BERS1;
    UN16 un16BERS2;
    UN16 un16BERT;
    UN8 un8CNS1A;
    UN8 un8CNS1B;
    UN8 un8CNS2A;
    UN8 un8CNS2B;
    UN16 un16RSErrsWords;
    UN16 un16RSErrsSatSymb;
    UN16 un16RRSErrsTerrSymb;
    N16 n16TunerCarrierFreqOffset;
    N16 n16RSSI;

} DETAILED_SIGNAL_QUALITY_STRUCT;

typedef struct detailed_overlay_signal_quality_struct
{
    UN8 un8ReceiverState;
    UN16 un16OberS1A;
    UN16 un16OberS2A;
    UN16 un16OberTA;
    UN16 un16OberS1B;
    UN16 un16OberS2B;
    UN16 un16OberTB;
    UN16 un16TurboWordErrorRate0A;
    UN16 un16TurboWordErrorRate1A;
    UN16 un16TurboWordErrorRate2A;
    UN16 un16TurboWordErrorRate0B;
    UN16 un16TurboWordErrorRate1B;
    UN16 un16TurboWordErrorRate2B;

} DETAILED_OVERLAY_SIGNAL_QUALITY_STRUCT;


typedef struct link_information_struct
{
    UN32 un32NumberConfirmTimeouts;
    UN32 un32NumberDataPacketsDropped;
    UN32 un32NumberDataPacketsTx;
    UN32 un32NumberAudioPacketsDropped;
    UN32 un32NumberAudioPacketsTx;

} LINK_INFORMATION_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
void ENGINEERING_DATA_vInitializeObject(
    ENGINEERING_DATA_OBJECT hEngineeringData
        );

ENGINEERING_DATA_OBJECT ENGINEERING_DATA_hCreate(
    DECODER_OBJECT hOwner
        );

void ENGINEERING_DATA_vDestroy (
    ENGINEERING_DATA_OBJECT hEngineeringData
        );

BOOLEAN ENGINEERING_DATA_bUpdateLinkStatusInformation(
    DECODER_OBJECT hDecoder,
    LINK_INFORMATION_STRUCT const *psNewLinkStatusInformation
        );

BOOLEAN ENGINEERING_DATA_bUpdateAudioDecoderBitrate(
    DECODER_OBJECT hDecoder,
    AUDIO_DECODER_BITRATE tNewAudioDecoderBitrate
        );

BOOLEAN ENGINEERING_DATA_bUpdateNewDetailedSignalQuality(
    DECODER_OBJECT hDecoder,
    DETAILED_SIGNAL_QUALITY_STRUCT const *psNewDetailedSignalQuality
        );

BOOLEAN ENGINEERING_DATA_bUpdateNewDetailedOverlaySignalQuality(
    DECODER_OBJECT hDecoder,
    DETAILED_OVERLAY_SIGNAL_QUALITY_STRUCT const *psNewDetailedOverlaySignalQuality
        );

#endif /* ENGINEERING_DATA_OBJ_*/
