/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:DSRL_ENTRY header file.
 *
 ******************************************************************************/

#ifndef DSRL_ENTRY_OBJ_H_
#define DSRL_ENTRY_OBJ_H_

#include "sms_api.h"
#include "dataservice_mgr_impl.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
DSRL_ENTRY_OBJECT DSRL_ENTRY_hCreate (
    const char *pacName,
    DSRL_ENTRY_TYPE_ENUM eType,
    size_t tDataSize,
    size_t tServiceDataSize,
    SMS_OBJECT hParent,
    BOOLEAN bLock
        );

SMS_OBJECT DSRL_ENTRY_hGetSMSObject (
    DSRL_ENTRY_OBJECT hEntry
        );

BOOLEAN DSRL_ENTRY_bLock (
    DSRL_ENTRY_OBJECT hEntry
        );

void DSRL_ENTRY_vUnLock (
    DSRL_ENTRY_OBJECT hEntry
        );

BOOLEAN DSRL_ENTRY_bOwner (
    DSRL_ENTRY_OBJECT hEntry
        );

SMS_OBJECT DSRL_ENTRY_hParent (
    DSRL_ENTRY_OBJECT hEntry
        );

void DSRL_ENTRY_vSetService (
    DSRL_ENTRY_OBJECT hEntry,
    DATASERVICE_IMPL_HDL hService
        );

void DSRL_ENTRY_vSetFavorite (
    DSRL_ENTRY_OBJECT hEntry,
    BOOLEAN bIsFavorite
        );

void DSRL_ENTRY_vDestroy (
    DSRL_ENTRY_OBJECT hEntry
        );

void *DSRL_ENTRY_pvServiceData (
    DSRL_ENTRY_OBJECT hEntry
        );

OSAL_LINKED_LIST_ENTRY DSRL_ENTRY_hDSRLListEntry (
    DSRL_ENTRY_OBJECT hEntry,
    DSRL_OBJECT hDSRL
        );

BOOLEAN DSRL_ENTRY_bAddToDSRL (
    DSRL_ENTRY_OBJECT hEntry,
    DSRL_OBJECT hDSRL,
    OSAL_LINKED_LIST_ENTRY hDSRLListEntry
        );

BOOLEAN DSRL_ENTRY_bRemoveFromDSRL (
    DSRL_ENTRY_OBJECT hEntry,
    DSRL_OBJECT hDSRL
        );

#endif /* DSRL_ENTRY_OBJ_H_ */
