/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:DISTANCE header file.
 *
 ******************************************************************************/

#ifndef DISTANCE_OBJ_H_
#define DISTANCE_OBJ_H_

#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

DISTANCE_OBJECT DISTANCE_hCreateFromDistanceVector (
    OSAL_FIXED_OBJECT  hValue
        );

BOOLEAN DISTANCE_bDistanceOverRadius (
    DISTANCE_OBJECT hDistance,
    OSAL_FIXED_OBJECT hResult
        );

N16 DISTANCE_n16CompareToDistanceVector (
    DISTANCE_OBJECT hDistance,
    OSAL_FIXED_OBJECT hVector
        );

DISTANCE_OBJECT DISTANCE_hCreateFromFixed (
    OSAL_FIXED_OBJECT  hValue,
    DISTANCE_UNIT_TYPE_ENUM eUnits
        );

#endif /* DISTANCE_OBJ_H_ */
