/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:DEVICE header file.
 *
 ******************************************************************************/

#ifndef DEVICE_H_
#define DEVICE_H_

#include <sms_api.h>

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct device_object * DEVICE_OBJECT;
#define DEVICE_INVALID_OBJECT (DEVICE_OBJECT)0

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

DEVICE_OBJECT DEVICE_hInstall(
    SMS_OBJECT hParent
        );

void DEVICE_vUninstall(
    DEVICE_OBJECT hDevice
        );

BOOLEAN DEVICE_bSetPosition (
    DEVICE_OBJECT hDevice,
    OSAL_FIXED_OBJECT hLat,
    OSAL_FIXED_OBJECT hLon
        );

DEVICE_REGISTRATION_OBJECT DEVICE_hRegisterForUpdates (
    DEVICE_OBJECT hDevice,
    N32 n32DistanceValue,
    DISTANCE_UNIT_TYPE_ENUM eDistanceUnits,
    void *pvRegistrationArgument,
    DEVICE_UPDATE_CALLBACK vCallback,
    void *pvCallbackArg
        );

BOOLEAN DEVICE_bUpdateLocWithCurrentDevLoc (
    DEVICE_OBJECT hDevice,
    LOCATION_OBJECT hLocation
        );

N32 DEVICE_n32FPrintf (
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

#endif /* DEVICE_H_ */
