/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the DB_UTIL header file.
 *
 ******************************************************************************/

#ifndef DB_UTIL_H_
#define DB_UTIL_H_

#include "osal.h"
#include "sms_api.h"
#include "sql_interface_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

#define DB_UTIL_DB_UNDER_CONSTRUCTION_VER ((DATASERVICE_REF_DATA_VER)-1)
#define DB_UTIL_INVALID_TIMESTAMP         (0)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Callback that is called when a DB was created
// This gives the caller a chance to create
// necessary tables and indices
//
// Returning FALSE from this function would indicate
// there was an error in creating the tables
typedef BOOLEAN (*DB_UTIL_CREATE_DB_HANDLER) (
    SQL_INTERFACE_OBJECT hSQLConnection,
    void *pvArg
        );

// Callback to have the user perform the version
// check for the database in whatever way they need to do it.
//
// Returning FALSE from this function would indicate
// that the version check failed.
typedef BOOLEAN (*DB_UTIL_CHECK_VERSION_HANDLER) (
    SQL_INTERFACE_OBJECT hSQLConnection,
    void *pvArg
        );

// Callback to have the user extract the version to
// allow DB_UTIL to compare two databases
typedef N32 (*DB_UTIL_EXTRACT_CONTENT_VERSION_HANDLER) (
    SQL_INTERFACE_OBJECT hSQLConnection,
    void *pvArg
        );

// Callback to have the user extract the timestamp to
// allow DB_UTIL to compare two databases
typedef UN32 (*DB_UTIL_EXTRACT_CONTENT_TIMESTAMP_HANDLER) (
    SQL_INTERFACE_OBJECT hSQLConnection
        );

// A single database timestamp result
typedef struct db_util_timestamp_result_struct
{
    TIME_T  tTimestamp;
    BOOLEAN bSuccess;

} DB_UTIL_TIMESTAMP_RESULT_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */


SQL_INTERFACE_OBJECT DB_UTIL_hConnectToPersistent (
    const char *pacDatabaseFile,
    DB_UTIL_CREATE_DB_HANDLER bCreateDBHandler,
    void *pvCreateArg,
    DB_UTIL_CHECK_VERSION_HANDLER bCheckVersionHandler,
    void *pvCheckArg,
    DATASERVICE_ERROR_CODE_ENUM *peErrorCode
        );

DATASERVICE_ERROR_CODE_ENUM DB_UTIL_eCheckReferenceBanks (
    const char *pacDatabaseFileA,
    const char *pacDatabaseFileB,
    DB_UTIL_EXTRACT_CONTENT_VERSION_HANDLER n32ExtractVersionHandler,
    void *pvExtractVersionHandler,
    size_t tVersionBitWidth,
    DATASERVICE_REF_DATA_VER *ptCurrentVer,
    DATASERVICE_REF_DATA_VER *ptNextVer
        );

SQL_INTERFACE_OBJECT DB_UTIL_hConnectToReferenceBank (
    const char *pacDatabaseFileA,
    const char *pacDatabaseFileB,
    const char **ppacSelectedFile,
    DB_UTIL_EXTRACT_CONTENT_VERSION_HANDLER n32ExtractVersionHandler,
    void *pvn32ExtractVersionHandlerArg,
    BOOLEAN bDeleteExpiredDB,
    BOOLEAN *pbDatabaseSwapped,
    size_t tVersionBitWidth,
    DB_UTIL_CHECK_VERSION_HANDLER bCheckVersionHandler,
    void *pvCheckArg,
    DATASERVICE_ERROR_CODE_ENUM *peErrorCode,
    SQL_INTERFACE_OPTIONS_MASK tOptions
        );

SQL_INTERFACE_OBJECT DB_UTIL_hConnectToReference (
    const char *pacDatabaseFile,
    DB_UTIL_CHECK_VERSION_HANDLER bCheckVersionHandler,
    void *pvCheckArg,
    DATASERVICE_ERROR_CODE_ENUM *peErrorCode,
    SQL_INTERFACE_OPTIONS_MASK tOptions
        );

BOOLEAN DB_UTIL_bUpdateTimestamp(
    SQL_INTERFACE_OBJECT hConnection,
    char *pcSQLCommandBuffer,
    size_t tBufferSize
        );

BOOLEAN DB_UTIL_bCreateFilePath (
    const char *pcContainingDirectoryPath,
    const char *pcFileDirectory,
    const char *pcFilename,
    char **ppcFullPath
        );

BOOLEAN DB_UTIL_bCopyDB (
    const char *pcDstDB,
    const char *pcSrcDB
        );

#endif /* DB_UTIL_H_ */
