/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This file defines the base types & constants used with data services.
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef DATASERVICE_BASE_H_
#define DATASERVICE_BASE_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"

#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

// Data Service identifier
typedef UN32 DATASERVICE_ID;
#define DATASERVICE_INVALID_ID ((DATASERVICE_ID)UN32_MAX)
#define DATASERVICE_MIN_ID ((DATASERVICE_ID)DSI_INVALID_ID)

// Define service Ids here
#define DATASERVICE_ID_EV (DATASERVICE_MIN_ID)
#define DATASERVICE_ID_FUEL_PRICES (DATASERVICE_ID_EV + 1)
#define DATASERVICE_ID_CANFUEL_PRICES (DATASERVICE_ID_FUEL_PRICES + 1)
#define DATASERVICE_ID_ART (DATASERVICE_ID_CANFUEL_PRICES + 1)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// data service framework event types
typedef enum dataservice_fw_event_enum
{
    // These are low-priority events (they are not
    // marked as urgent in the queue)
    DATASERVICE_FW_EVENT_INITIAL = 0,
    DATASERVICE_FW_EVENT_SERVICE_ERROR,
    DATASERVICE_FW_EVENT_MANAGE_DATA_STREAM,
    DATASERVICE_FW_EVENT_MODULE_ASSOCIATE,
    DATASERVICE_FW_EVENT_MODULE_UNASSOCIATE,
    DATASERVICE_FW_EVENT_STOP,
    DATASERVICE_FW_EVENT_AUTONOMOUS_STOP,
    DATASERVICE_FW_EVENT_DECODER_SUBSCRIBED,
    DATASERVICE_FW_EVENT_DECODER_UNSUBSCRIBED,
    DATASERVICE_FW_EVENT_DSRL,
    DATASERVICE_FW_EVENT_DEVICE_RADIUS,
    DATASERVICE_FW_EVENT_TIMEOUT,
    DATASERVICE_FW_EVENT_SERVICE_SPECIFIC,
    DATASERVICE_FW_EVENT_PRODUCT_ENABLE,
    DATASERVICE_FW_EVENT_PRODUCT_DISABLE,
    DATASERVICE_FW_EVENT_PRODUCT_ERROR,
    DATASERVICE_FW_EVENT_TIME_AVAILABLE,
    DATASERVICE_FW_EVENT_START_TIMED_EVENT,
    DATASERVICE_FW_EVENT_STOP_TIMED_EVENT,
    DATASERVICE_FW_EVENT_SXI_MESSAGE,

    // This marks the end of the low-priority events
    DATASERVICE_FW_UPDATE_LOW_PRIORITY_END
        = DATASERVICE_FW_EVENT_SXI_MESSAGE,

    // All high-priority data service events must be
    // placed after DATASERVICE_FW_UPDATE_LOW_PRIORITY_END

    // Device position updates are needed ASAP
    DATASERVICE_FW_EVENT_DEVICE_POSITION,

} DATASERVICE_FW_EVENT_ENUM;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

#endif /* DATASERVICE_BASE_H_ */
