/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the generic CID STRING type header file.
 *
 ******************************************************************************/

#ifndef CID_STRING_H_
#define CID_STRING_H_

#include "cid_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

// External CID Type Interface (STRINGs) Object Data Interface
extern const CID_TYPE_OBJ_DATA_INTERFACE_STRUCT GsCidStringIntf;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

const void *CIDSTR_pvCreate (
    const void *pvSrcObjectData,
    size_t tMinimumSize,
    SMS_OBJECT hParent,
    BOOLEAN bConstant
        );

void CIDSTR_vDestroy (
    const void *pvObject
        );

const void *CIDSTR_pvDuplicate (
    const void *pvObject
        );

BOOLEAN CIDSTR_bModify (
    const void **ppvObject,
    const void *pvSrcObjectData
        );

BOOLEAN CIDSTR_bCopy (
    void **ppvDstObject,
    const void *pvSrcObject
        );

size_t CIDSTR_tSize(
    const void *pvObject
        );

N16 CIDSTR_n16Compare (
    const void *pvObject1,
    const void *pvObject2,
    BOOLEAN bBinary
        );

N32 CIDSTR_n32FWrite (
    const void *pvObject,
    FILE *psFile
        );

N32 CIDSTR_n32FWriteToMemory (
    const void *pvObject,
    void **ppvMemory
        );

const void *CIDSTR_pvRead (
    FILE *psFile
        );

N32 CIDSTR_n32FPrintf (
    const void *pvObject,
    FILE *psFile
        );

BOOLEAN CIDSTR_bReadFromMemory(
    const void **ppvObjectData,
    void **ppvMemory,
    SMS_OBJECT hParent
        );

N32 CIDSTR_n32GetValue (
    const void *pvObject,
    void **ppvValue
        );

#endif /* CID_STRING_H */
