/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Channel Art Interface header file.
 *
 ******************************************************************************/

#ifndef CHANNEL_ART_INTERFACE_H_
#define CHANNEL_ART_INTERFACE_H_

#include "sms_api.h"
#include "channel_art_db_constants.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Interface handle
typedef void * CHANNEL_ART_INTERFACE_OBJECT;
#define CHANNEL_ART_INTERFACE_INVALID_OBJECT \
            (CHANNEL_ART_INTERFACE_OBJECT)NULL

typedef void * ALBUM_ART_INTERFACE_OBJECT;
#define ALBUM_ART_INTERFACE_INVALID_OBJECT \
            (ALBUM_ART_INTERFACE_OBJECT)NULL

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

typedef enum channel_art_mgr_process_assoc_enum
{
    CHANNEL_ART_MGR_PROCESS_ASSOC_BEGIN,
    CHANNEL_ART_MGR_PROCESS_ASSOC_IGNORE,
    CHANNEL_ART_MGR_PROCESS_ASSOC_ERROR

} CHANNEL_ART_MGR_PROCESS_ASSOC_ENUM;

// The channel art manager interface APIs
typedef struct channel_art_mgr_interface_struct
{
    CHANNEL_ART_MGR_PROCESS_ASSOC_ENUM (*eChanArtAssocBegin) (
        CHANNEL_ART_SERVICE_OBJECT hChannelArtService,
        CHANNEL_ART_IMAGETYPE_ENUM eBaseImageType,
        BOOLEAN bVerifyLineup,
        BOOLEAN bCategory,
        BOOLEAN bOverlay
            );

    BOOLEAN (*bChanArtAssocEnd) (
        CHANNEL_ART_SERVICE_OBJECT hChannelArtService
            );

    BOOLEAN (*bChanArtAssociationUpdate) (
        CHANNEL_ART_SERVICE_OBJECT hChannelArtService,
        CHANNEL_ART_ASSOC_ROW_STRUCT *psNewAssoc,
        BOOLEAN *pbAssociationPending
            );

    BOOLEAN (*bChanArtResetAssociations) (
        CHANNEL_ART_SERVICE_OBJECT hChannelArtService,
        BOOLEAN bContentOnly,
        BOOLEAN bOverlay,
        BOOLEAN bCategory
            );

    BOOLEAN (*bChanArtImageUpdate) (
        CHANNEL_ART_SERVICE_OBJECT hChannelArtService,
        CHANNEL_ART_ATTRIB_ROW_STRUCT *psAttribRow,
        size_t tImageDataByteLen,
        OSAL_BUFFER_HDL hImageData
            );

    BOOLEAN (*bAlbumArtImageUpdate) (
            CHANNEL_ART_SERVICE_OBJECT hChannelArtService,
            ALBUM_ART_ASSOC_ROW_STRUCT *psAssocRow,
            OSAL_BUFFER_HDL hImageData,
            STRING_OBJECT *phCaption,
            CHANNEL_ART_OBJECT *phArtToUpdate
            );

    BOOLEAN (*bAlbumArtAssociationUpdate) (
            CHANNEL_ART_SERVICE_OBJECT hChannelArtService,
            ALBUM_ART_ASSOC_ROW_STRUCT *psAssocRow,
            CHANNEL_ART_OBJECT *phArtToUpdate
            );

    BOOLEAN (*bAlbumArtAssocBegin) (
        CHANNEL_ART_SERVICE_OBJECT hChannelArtService
            );

    BOOLEAN (*bAlbumArtAssocEnd) (
        CHANNEL_ART_SERVICE_OBJECT hChannelArtService
            );

} CHANNEL_ART_MGR_INTERFACE_STRUCT;

// The channel art plugin interface APIs
typedef struct channel_art_plugin_interface_struct
{
    const DSI tDSI;

    const size_t tOTABufferByteSize;

    const SERVICE_ID tStartServiceID;
    const SERVICE_ID tEndServiceID;

    const SERVICE_ID tOverlayStartServiceID;
    const SERVICE_ID tOverlayEndServiceID;

    CHANNEL_ART_INTERFACE_OBJECT (*hInit) (
        CHANNEL_ART_SERVICE_OBJECT hChannelArtService,
        SMS_OBJECT hParent
            );

    void (*vUnInit) (
        CHANNEL_ART_INTERFACE_OBJECT hInterface
            );

    BOOLEAN (*bProcessMessage) (
        CHANNEL_ART_INTERFACE_OBJECT hInterface,
        OSAL_BUFFER_HDL *phPayload
            );

    void (*vAllAssociationsCompleted) (
        CHANNEL_ART_INTERFACE_OBJECT hInterface
            );

    void (*vResetAssociationTracking) (
        CHANNEL_ART_INTERFACE_OBJECT hInterface
            );

    BOOLEAN  (*bCompareAssociationVersions) (
        CHANNEL_ART_ASSOC_ROW_STRUCT *psOldAssocRow,
        CHANNEL_ART_ASSOC_ROW_STRUCT *psNewAssocRow,
        BOOLEAN *pbOldNeedsConfirmation
            );

    BOOLEAN (*bCompareImageVersions) (
        CHANNEL_ART_ATTRIB_ROW_STRUCT *psOldAttribRow,
        CHANNEL_ART_ATTRIB_ROW_STRUCT *psNewAttribRow,
        BOOLEAN *pbImageCompatible
            );

} CHANNEL_ART_PLUGIN_INTERFACE_STRUCT;


// The album art plugin interface APIs
typedef struct album_art_plugin_interface_struct
{
    const DSI tDSI;

    const size_t tOTABufferByteSize;

    const SERVICE_ID tStartServiceID;
    const SERVICE_ID tEndServiceID;

    ALBUM_ART_INTERFACE_OBJECT (*hInit) (
        CHANNEL_ART_SERVICE_OBJECT hChannelArtService,
        SMS_OBJECT hParent
            );

    void (*vUnInit) (
        CHANNEL_ART_INTERFACE_OBJECT hInterface
            );

    BOOLEAN (*bProcessMessage) (
        CHANNEL_ART_INTERFACE_OBJECT hInterface,
        OSAL_BUFFER_HDL *phPayload
            );

} ALBUM_ART_PLUGIN_INTERFACE_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

extern const CHANNEL_ART_MGR_INTERFACE_STRUCT GsArtMgrIntf;
extern const CHANNEL_ART_PLUGIN_INTERFACE_STRUCT GsChannelArtIntf;
extern const ALBUM_ART_PLUGIN_INTERFACE_STRUCT GsAlbumArtIntf;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

#endif /* CHANNEL_ART_INTERFACE_H_ */
