/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:CDO header file.
 *
 ******************************************************************************/

#ifndef CDO_OBJ_H_
#define CDO_OBJ_H_

#include "sms_api.h"
#include "cid_obj.h"
#include "radio.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

typedef BOOLEAN (*CDO_ID_PARSER)(CD_OBJECT hCDO, const void *pvArg);
#define CDO_INVALID_ID_PARSER (CDO_ID_PARSER)NULL

#define CDO_PID_MUSIC_MASK (0x40000000)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// A constant instance of this structure must be defined for each
// CDO supported. Each CDO must populate the structure with it's
// own initialization defaults.
// This interface is used by specific CDOs to overload the
// CDO base implementations which are defaults implementations.
typedef struct cdo_interface_struct
{
    // SMS initialization (called once)
    BOOLEAN (*bInitialize) ( void );

    // SMS uninitialization (called once)
    void (*vUnInitialize) ( void );

    // CDO Uninitialize Method
    void (*vUnInit) (
        void *psObj
            );

    // CDO Equality
    N16 (*n16Equal) (
        const void *psObj1,
        const void *psObj2
            );

    // CDO Comparator
    N16 (*n16Compare) (
        const void *psObj1,
        const void *psObj2
            );

    // CDO Printer
    N32 (*n32FPrintf) (
        const void *psObj,
        FILE *psFile
            );

    // CDO 'has id?' method
    BOOLEAN (*bHasId) (
        const void *psObj,
        CID_OBJECT hId
            );

} CDO_INTERFACE_STRUCT;

// This structure contains all the constant (compile-time)
// information regarding an individual CDO. This is used
// to populate a table of all known CDOs.
typedef struct cdo_info_struct
{
    // The CDO type (which makes it a specific CDO)
    CDO_TYPE_ENUM eType;

    // CDO type text
    const char *pacTypeText;

    // The description of this content type
    const char *pacDescription;

    // Default object initialization data
    const void *pvDefaultObjData;

    // CDO Interface
    const CDO_INTERFACE_STRUCT *psInterface;

} CDO_INFO_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN CDO_bInitialize ( void );

void CDO_vUnInitialize( void );

void CDO_vAssignParser (
    CDO_TYPE_ENUM eType,
    CID_OBJECT hId,
    CDO_ID_PARSER bParser
        );

void CDO_vUpdate (
    CHANNEL_OBJECT hChannel,
    const char *pacText,
    CDO_FIELD_MASK tMask
        );

CD_OBJECT CDO_hCreate (
    CHANNEL_OBJECT hChannel
        );

CDO_ID_PARSER CDO_bAssignType (
    CD_OBJECT hCDO,
    CDO_TYPE_ENUM eType
        );

void CDO_vAssignPID (
    CD_OBJECT hCDO,
    PROGRAM_ID tProgramId
        );

PROGRAM_ID CDO_tGetPID (
    CD_OBJECT hCDO
        );

void CDO_vDestroy (
    CD_OBJECT hCDO
        );

void *CDO_pvContentData (
    CD_OBJECT hCDO
        );

CD_OBJECT CDO_hCDO (
    const void *pvContentData
        );

BOOLEAN CDO_bHasId (
    CD_OBJECT hCDO,
    CID_OBJECT hId
        );

CID_OBJECT CDO_hCidCreate (
	CD_OBJECT hCDO,
    CID_ENUM eType,
    const void *pvObjectDataPtr
        );

void CDO_vUpdateArt (
    CD_OBJECT hCDO,
    CHANNEL_OBJECT hChannel
        );

#endif /* CDO_OBJ_H */
