/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:Category header file.
 *
 ******************************************************************************/

#ifndef CATEGORY_OBJ_H_
#define CATEGORY_OBJ_H_

#include "standard.h"
#include "sms_api.h"
#include "dataservice_mgr_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

// All events except CATEGORY_OBJECT_EVENT_REMOVED
// Used for initial configuration of even notification
// for CATEGORY object.
#define CATEGORY_OBJECT_EVENT_INITIAL \
    (CATEGORY_OBJECT_EVENT_ALL & ~(CATEGORY_OBJECT_EVENT_REMOVED))

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN CATEGORY_bUpdateId(
    CATEGORY_OBJECT hCategory,
    CATEGORY_ID tCategoryId
        );

CATEGORY_ID  CATEGORY_tCreateVirtualCategory (
    DECODER_OBJECT hDecoder,
    const char *pacLongName,
    const char *pacShortName,
    CATEGORY_CHANNEL_INDEX tInitialNumChannels,
    BOOLEAN bUniqueItems,
    BOOLEAN bReplace
        );

CATEGORY_OBJECT CATEGORY_hCreateCategory (
    DECODER_OBJECT hDecoder,
    SMS_OBJECT hParent,
    CATEGORY_TYPE_ENUM eCategoryType,
    CATEGORY_ID tId,
    const char *pacLongName,
    const char *pacMediumName,
    const char *pacShortName,
    CATEGORY_CHANNEL_INDEX tInitialNumChannels,
    BOOLEAN bUniqueItems,
    BOOLEAN bReplace
        );

void CATEGORY_vDestroy (
    CATEGORY_OBJECT hCategory
        );

void CATEGORY_vUpdateArtService (
    CATEGORY_OBJECT hCategory,
    CHANNEL_ART_SERVICE_OBJECT hChannelArtService
        );

void CATEGORY_vUpdateArt (
    CATEGORY_OBJECT hCategory,
    BOOLEAN bRefreshArtHandle
        );

BOOLEAN CATEGORY_bAddChannel (
    CATEGORY_OBJECT hCategory,
    CHANNEL_OBJECT hChannel
        );

void CATEGORY_vRemoveChannel (
    CATEGORY_OBJECT hCategory,
    CHANNEL_OBJECT hChannel,
    BOOLEAN bSuppressCatEvents
        );

BOOLEAN CATEGORY_bIdInRange (
    CATEGORY_TYPE_ENUM eCategoryType,
    CATEGORY_ID tCategoryId
        );

BOOLEAN CATEGORY_bCategoryIdRange (
    CATEGORY_TYPE_ENUM eCategoryType,
    CATEGORY_ID *ptStartCategoryId,
    CATEGORY_ID *ptEndCategoryId
        );

N16 CATEGORY_n16CompareCategoryIds (
	void *pvArg1,
	void *pvArg2
		);

CHANNEL_OBJECT CATEGORY_hGetChanHdlByOffset (
	CATEGORY_OBJECT hCategory,
	N16 n16Offset
		);

N16 CATEGORY_n16GetIndexByChanId (
	CATEGORY_OBJECT hCategory,
	CHANNEL_ID tChannelId
		);

N16 CATEGORY_n16GetIndexByServiceId(
    CATEGORY_OBJECT hCategory,
    SERVICE_ID tServiceId
        );

N16 CATEGORY_n16ChannelOccurrence (
    CATEGORY_OBJECT hCategory,
    CHANNEL_OBJECT hChannel,
    N16 n16IndexLimit
        );

BOOLEAN CATEGORY_bRegisterNotification (
    CATEGORY_OBJECT hCategory,
    CATEGORY_EVENT_MASK tEventRequestMask,
    CATEGORY_OBJECT_EVENT_CALLBACK vEventCallback,
    void *pvEventCallbackArg
        );

BOOLEAN CATEGORY_bNotifyIfPending (
    CATEGORY_OBJECT hCategory,
    CATEGORY_OBJECT_EVENT_CALLBACK vEventCallback,
    void *pvCallbackArg
        );

void CATEGORY_vUnregisterNotification (
    CATEGORY_OBJECT hCategory,
    CATEGORY_OBJECT_EVENT_CALLBACK vEventCallback,
    void *pvEventCallbackArg
        );

SMSAPI_RETURN_CODE_ENUM CATEGORY_eRename (
    DECODER_OBJECT hDecoder,
    CATEGORY_ID tCategoryId,
    const char *pacNewLongName,
    const char *pacNewMedName,
    const char *pacNewShortName
        );

SMSAPI_RETURN_CODE_ENUM CATEGORY_eReplaceChannel (
    CATEGORY_OBJECT hCategory,
    CHANNEL_OBJECT hChannel
        );

SMSAPI_RETURN_CODE_ENUM CATEGORY_eInsertAfterChannel (
    CATEGORY_OBJECT hCategory,
    CHANNEL_OBJECT hChannel
        );

SMSAPI_RETURN_CODE_ENUM CATEGORY_eInsertBeforeChannel (
    CATEGORY_OBJECT hCategory,
    CHANNEL_OBJECT hChannel
        );

SMSAPI_RETURN_CODE_ENUM CATEGORY_eInsertNewChannel (
    DECODER_OBJECT hDecoder,
    CATEGORY_ID tCategoryId,
    CHANNEL_OBJECT hChannel
        );

SMSAPI_RETURN_CODE_ENUM CATEGORY_eFill (
    DECODER_OBJECT hDecoder,
    CATEGORY_ID tCategoryId,
    CHANNEL_OBJECT *phChannel,
    size_t tArraySize
        );

SMSAPI_RETURN_CODE_ENUM CATEGORY_eSerialize (
    DECODER_OBJECT hDecoder,
    CATEGORY_ID tCategoryId,
    TAG_OBJECT hParentTag
        );

CATEGORY_ID CATEGORY_tCreateFromTags (
    DECODER_OBJECT hDecoder,
    TAG_OBJECT hParentTag
        );

const char *CATEGORY_pacTagName ( void );

SMSAPI_RETURN_CODE_ENUM CATEGORY_eSort(
    CATEGORY_OBJECT hCategory,
    CATEGORY_SORT_HANDLER n16SortFxn
        );

BOOLEAN CATEGORY_bBlockNotifications(
    DECODER_OBJECT hDecoder,
    CATEGORY_ID tCategoryId
        );

void CATEGORY_vReleaseNotifications (
    DECODER_OBJECT hDecoder,
    CATEGORY_ID tCategoryId
        );

#endif /* CATEGORY_OBJ_H */
