/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:CAS header file.
 *
 ******************************************************************************/

#ifndef CAS_H_
#define CAS_H_

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/


  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/
extern const CONTENT_ALERT_LIST_INTERFACE_STRUCT CAL;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/
CAL_OBJECT CAS_hCreateList (
    DECODER_OBJECT hDecoder,
    CAL_CALLBACK vCALCallback,
    void *pvCALCallbackArg,
    BOOLEAN bAutoAck
        );

DECODER_OBJECT CAL_hDecoder(
    CAL_OBJECT hCAL
        );

CAL_AUTO_ADD_OPTIONS CAL_tCatAddOptions (
    CAL_OBJECT hCAL
        );

CAL_ALERT_OBJECT CAL_hGetNextActiveEvent(
    CAL_OBJECT hCAL
        );

BOOLEAN CAL_bGetAlertsTunedStatus(
    CAL_OBJECT hCAL
        );

SMSAPI_RETURN_CODE_ENUM CAL_eEnableAlertsTuned(
    CAL_OBJECT hCAL,
    BOOLEAN bEnable
        );

BOOLEAN CAL_bGetAlertsFinishedStatus(
    CAL_OBJECT hCAL
        );

SMSAPI_RETURN_CODE_ENUM CAL_eEnableAlertsFinished(
    CAL_OBJECT hCAL,
    BOOLEAN bEnable
        );

SMSAPI_RETURN_CODE_ENUM CAL_hGetNextEndedEventAttributes(
    CAL_OBJECT hCAL,
    CHANNEL_ID *ptChannelId,
    STRING_OBJECT *phArtist,
    STRING_OBJECT *phTitle
        );

SMSAPI_RETURN_CODE_ENUM CAL_eAcknowledge(
    CAL_OBJECT hCAL
        );

#endif /* CAS_H_ */
