/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:CAL_CONTENT header file.
 *
 ******************************************************************************/

#ifndef CAL_CONTENT_H_
#define CAL_CONTENT_H_

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

CAL_CONTENT_OBJECT CAL_CONTENT_hCreate (
    void *pvContentArg,
    UN32 un32Options,
    STRING_OBJECT hArtist,
    STRING_OBJECT hTitle,
    CAL_OBJECT hCAL,
    CEML_OBJECT hCEML
        );

void CAL_CONTENT_vDestroy (
    CAL_CONTENT_OBJECT hContent
        );

SMSAPI_RETURN_CODE_ENUM CAL_CONTENT_eAddToAlertList (
    CAL_CONTENT_OBJECT hContent,
    CAL_ALERT_OBJECT hAlert
        );

CAL_ALERT_OBJECT CAL_CONTENT_hGetAlert (
    CAL_CONTENT_OBJECT hContent,
    CHANNEL_OBJECT hChannel
        );

SMSAPI_RETURN_CODE_ENUM CAL_CONTENT_eRemoveFromAlertList (
    CAL_CONTENT_OBJECT hContent,
    CHANNEL_OBJECT hChannel
        );

BOOLEAN CAL_CONTENT_bLookForChannelInAlertList (
	CAL_CONTENT_OBJECT hContent,
	CHANNEL_OBJECT hChannel
	    );

SMSAPI_RETURN_CODE_ENUM CAL_CONTENT_eUpdateContentArg (
    CAL_CONTENT_OBJECT hContent,
    void *pvContentArg
        );

#endif /* CAL_CONTENT_H_ */
