/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:AT_SEEK header file.
 *
 ******************************************************************************/

#ifndef AT_SEEK_CONTENT_H_
#define AT_SEEK_CONTENT_H_

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

//  structure used to contain data assocaited with items
//  registered with the service
typedef struct at_seek_content_registered_item_struct
{
    // type of seek this content is registered for
    AT_SEEK_ENUM eType;

    // identifier for artist
    CID_OBJECT hArtistCID;

    // identifier for title
    CID_OBJECT hTitleCID;

} AT_SEEK_CONTENT_REGISTERED_ITEM_STRUCT;


  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

void AT_SEEK_CONTENT_vSetServiceSpecificInfo(
    void *pvItem,
    CID_OBJECT hArtistCID,
    CID_OBJECT hTitleCID,
    AT_SEEK_ENUM eType,
    SEEK_SERVICE_OBJECT hSeekService
        );

CID_OBJECT AT_SEEK_CONTENT_hArtistCID (
    SEEK_CONTENT_OBJECT hSeekContent
        );

CID_OBJECT AT_SEEK_CONTENT_hTitleCID (
    SEEK_CONTENT_OBJECT hSeekContent
        );

const char *AT_SEEK_CONTENT_pacATSeekTypeText(
    AT_SEEK_ENUM eType
        );

#endif /* AT_SEEK_CONTENT_H_ */
