/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:ALERTC_EVENT header file.
 *
 ******************************************************************************/

#ifndef ALERTC_EVENT_OBJ_H_
#define ALERTC_EVENT_OBJ_H_

#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/


  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef struct alertc_event_object * ALERTC_EVENT_OBJECT;
#define ALERTC_EVENT_INVALID_OBJECT (ALERTC_EVENT_OBJECT)NULL

typedef UN16 ALERTC_SUPPL_INFO_CODE;
#define ALERTC_SUPPL_INFO_INVALID_CODE (ALERTC_SUPPL_INFO_CODE)0

typedef enum alertc_event_type_enum
{
    ALERTC_EVENT_TYPE_UNKNOWN,
    ALERTC_EVENT_TYPE_INCIDENT,
    ALERTC_EVENT_TYPE_CANCELLED,
    ALERTC_EVENT_TYPE_SPEED_AND_FLOW
} ALERTC_EVENT_TYPE_ENUM;

typedef enum alertc_quantifier_type_enum
{
    ALERTC_QUANTIFIER_TYPE_NUM=0,
    ALERTC_QUANTIFIER_TYPE_BIGNUM,
    ALERTC_QUANTIFIER_TYPE_VISIBILITY,
    ALERTC_QUANTIFIER_TYPE_PROBABILITY,
    ALERTC_QUANTIFIER_TYPE_SPEED,
    ALERTC_QUANTIFIER_TYPE_DELAY,
    ALERTC_QUANTIFIER_TYPE_TEMP,
    ALERTC_QUANTIFIER_TYPE_TIME,
    ALERTC_QUANTIFIER_TYPE_WEIGHT,
    ALERTC_QUANTIFIER_TYPE_LENGTH,
    ALERTC_QUANTIFIER_TYPE_DEPTH,
    ALERTC_QUANTIFIER_TYPE_FREQ_MHZ,
    ALERTC_QUANTIFIER_TYPE_FREQ_KHZ,
    ALERTC_QUANTIFIER_TYPE_UNKNOWN
} ALERTC_QUANTIFIER_TYPE_ENUM;


  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
ALERTC_EVENT_OBJECT ALERTC_EVENT_hCreate (
    SMS_OBJECT hOwner,
    TRAFFIC_EVENT_CODE tCode,
    ALERTC_EVENT_TYPE_ENUM eType,
    TRAFFIC_MSG_CLASS_ENUM eClass,
    ALERTC_QUANTIFIER_TYPE_ENUM eQuantType,
    STRING_OBJECT hText,
    STRING_OBJECT hTextMod
        );

TRAFFIC_EVENT_CODE ALERTC_EVENT_tEventCode (
    ALERTC_EVENT_OBJECT hEventInfo
        );

ALERTC_EVENT_TYPE_ENUM ALERTC_EVENT_eType (
    ALERTC_EVENT_OBJECT hEventInfo
        );

TRAFFIC_MSG_CLASS_ENUM ALERTC_EVENT_eClass (
    ALERTC_EVENT_OBJECT hEventInfo
        );

ALERTC_QUANTIFIER_TYPE_ENUM ALERTC_EVENT_eQuantType (
    ALERTC_EVENT_OBJECT hEventInfo
        );

STRING_OBJECT ALERTC_EVENT_hText (
    ALERTC_EVENT_OBJECT hEventInfo
        );

STRING_OBJECT ALERTC_EVENT_hTextMod (
    ALERTC_EVENT_OBJECT hEventInfo
        );

N16 ALERTC_EVENT_n16Compare(
    ALERTC_EVENT_OBJECT hEventInfo1,
    ALERTC_EVENT_OBJECT hEventInfo2
        );

void ALERTC_EVENT_vDestroy (
    ALERTC_EVENT_OBJECT hEventInfo
        );

BOOLEAN ALERTC_EVENT_bSetEventCode (
    ALERTC_EVENT_OBJECT hEventInfo,
    TRAFFIC_EVENT_CODE tCode
        );


#endif /* ALERTC_OBJ_H_ */
