/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:AGW_TILE header file.
 *
 ******************************************************************************/

#ifndef AGW_TILE_OBJ_H_
#define AGW_TILE_OBJ_H_

#include "sms_api.h"
#include "agw_mgr_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

AGW_TILE_OBJECT AGW_TILE_hCreate(
    SMS_OBJECT hParent,
    const char *pacFilePath,
    IMAGE_FORMAT_ENUM eFormat,
    size_t tDescriptorSize
        );

BOOLEAN AGW_TILE_bUpdate(
    AGW_TILE_OBJECT hAgwTile,
    AGW_PRODUCT_HEADER_STRUCT *psHeader,
    AGW_RASTER_PLANE_ENUM ePlane
        );

void AGW_TILE_vDestroy(
    AGW_TILE_OBJECT hAgwTile
        );

N16 AGW_TILE_n16CompareByCenter(
    AGW_TILE_OBJECT hAgwTile1,
    AGW_TILE_OBJECT hAgwTile2
        );

BOOLEAN AGW_TILE_bEqualByLocation(
    AGW_TILE_OBJECT hAgwTile1,
    AGW_TILE_OBJECT hAgwTile2
        );

AGW_BOUNDING_BOX_STRUCT *AGW_TILE_psBoundingBox(
    AGW_TILE_OBJECT hAgwTile
        );

#endif /* AGW_TILE_OBJ_H_ */
