/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:AGW_STORM_ATTRIBUTES header file.
 *
 ******************************************************************************/

#ifndef AGW_STORM_ATTRIBUTES_OBJ_H_
#define AGW_STORM_ATTRIBUTES_OBJ_H_


#include "sms_api.h"
#include "agw_mgr_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct agw_storm_attributes_data_struct {
    // Storm ID
    STRING_OBJECT hStormID;

    // Observation time
    TIME_T tObservationTime;

    // Echo Top Height
    AGW_FIXED_OBJECT_STRUCT sEchoTop;

    // Direction
    AGW_FIXED_OBJECT_STRUCT sDirection;
    BOOLEAN bDirectionAvailable;

    // Speed
    AGW_FIXED_OBJECT_STRUCT sSpeed;
    BOOLEAN bSpeedAvailable;

    // Hail probable flag
    BOOLEAN bHailProbable;

    // Hail positive flag
    BOOLEAN bHailPositive;

    // Mesocyclonic flag
    BOOLEAN bMesocyclonic;

    // Tornadic flag
    BOOLEAN bTornadic;
} AGW_STORM_ATTRIBUTES_DATA_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

AGW_STORM_ATTRIBUTES_OBJECT AGW_STORM_ATTRIBUTES_hCreate(
    SMS_OBJECT hParent,
    size_t tDescriptorSize,
    AGW_PRODUCT_HEADER_STRUCT *psHeader
        );

BOOLEAN AGW_STORM_ATTRIBUTES_bUpdate(
    AGW_STORM_ATTRIBUTES_OBJECT hAgwStormAttr,
    AGW_STORM_ATTRIBUTES_DATA_STRUCT *psData
        );

void AGW_STORM_ATTRIBUTES_vDestroy(
    AGW_STORM_ATTRIBUTES_OBJECT hAgwStormAttr
        );

#endif /* AGW_STORM_ATTRIBUTES_OBJ_H_ */
