/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio Inc.               */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio Inc.      */
/*                           Proprietary & Confidential                       */
/******************************************************************************/
/*******************************************************************************
*
* DESCRIPTION
*
* PRIVATE HEADER
*
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _WSI_PLATFORM_PORT_H_
#define _WSI_PLATFORM_PORT_H_

  /**************/
 /** INCLUDES **/
/**************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

 /***************/
 /** CONSTANTS **/
/***************/

// Object name
#define WSI_DECODER_OBJECT_NAME "WSI_DECODER"

#if SMS_DEBUG==1
// Log file extension
#define WSI_DECODER_RXOUT_DEFRAMED_LOG_EXT ".log"
#endif

// RXOUT file extension
#define WSI_DECODER_RXOUT_EXT ".rxout"

// Shared buffer max size
#define WSI_DECODER_SHARED_BUFFER_SIZE (256)

  /**************/
 /** TYPEDEFS **/
/**************/

// Defines raster file generation function
typedef TMW_ResultCode (*WSI_CONVERT_RASTER_FUNC) (
    const TASCIIChar *pstr_rasterProductPath,
    const TASCIIChar *pstr_outputPNGFilePath,
    TMW_CompressionType sourceCompressionType,
    TByte_Unsigned planeNumber
        );

// WSI Decoder Interface object
typedef struct wsi_decoder_object_struct
{
    // Keeps reference to buffer for WSI decoder input data
    char *pWsiInputData;

    // Keeps WSI decoder input data buffer size in bytes
    UN32 un32WsiInputDataSize;

    // Keeps appropriate conver function
    WSI_CONVERT_RASTER_FUNC tRasterConvertFunc;

    // Shared buffer for generic purposes
    char aBuffer[WSI_DECODER_SHARED_BUFFER_SIZE];

    // Plane number to decode. By default 0, means to decode all planes
    // Applicable for WINDS product type only
    UN8 un8PlaneNum;
} WSI_DECODER_OBJECT_STRUCT;

// Defines WSI Decoder returning code map item
typedef struct wsi_decoder_result_code_map_struct
{
    // Code value
    TMW_ResultCode eResultCode;

    // Test representation
    const char *pacText;
} WSI_DECODER_RESULT_CODE_MAP_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static WSI_DECODER_OBJECT hInit (
    SMS_OBJECT hParent,
    IMAGE_FORMAT_ENUM eFormat
        );

static BOOLEAN bDecodePayload(
    WSI_DECODER_OBJECT hWsiDecoder,
    OSAL_BUFFER_HDL hPayload,
    const char *paOutputFile
        );

static BOOLEAN bGenerateRaster(
    WSI_DECODER_OBJECT hWsiDecoder,
    const char *paDeframedFile,
    const char *paOutputFile
        );

static BOOLEAN bSetPlane(
    WSI_DECODER_OBJECT hWsiDecoder,
    UN8 un8Plane
        );

static void vUninit (
    WSI_DECODER_OBJECT hWsiDecoder
        );

#if SMS_DEBUG == 1
static const char *pacGetReturnCodeName (
    TMW_ResultCode eResultCode
        );
#endif

  /***************/
 /** VARIABLES **/
/***************/

const WSI_DECODER_INTERFACE_STRUCT GsWsiDecoderIntf =
{
  /*.hInit = */hInit,
  /*.bDecodePayload */bDecodePayload,
  /*.bGenerateRaster */bGenerateRaster,
  /*.bSetPlane */bSetPlane,
  /*.vUninit = */vUninit
};

// Keeps mapping for WSI decoder resulting code to string representation
static const WSI_DECODER_RESULT_CODE_MAP_STRUCT GsResultCodeMap[] = {
    {MWRes_OperationFailed,
        MACRO_TO_STRING(MWRes_OperationFailed)},
    {MWRes_Success,
        MACRO_TO_STRING(MWRes_Success)},
    {MWRes_EndOfIteration,
        MACRO_TO_STRING(MWRes_EndOfIteration)},
    {MWRes_NoMatchFound,
        MACRO_TO_STRING(MWRes_NoMatchFound)},
    {MWRes_EndOfDeflatedData,
        MACRO_TO_STRING(MWRes_EndOfDeflatedData)},
    {MWRes_InputBufferExhausted,
        MACRO_TO_STRING(MWRes_InputBufferExhausted)},
    {MWRes_BadCallingOrder,
        MACRO_TO_STRING(MWRes_BadCallingOrder)},
    {MWRes_BadParamValue,
        MACRO_TO_STRING(MWRes_BadParamValue)},
    {MWRes_NullPointer,
        MACRO_TO_STRING(MWRes_NullPointer)},
    {MWRes_StringTooLong,
        MACRO_TO_STRING(MWRes_StringTooLong)},
    {MWRes_DataStructureFull,
        MACRO_TO_STRING(MWRes_DataStructureFull)},
    {MWRes_InflationError,
        MACRO_TO_STRING(MWRes_InflationError)},
    {MWRes_UnrecognizedHeaderType,
        MACRO_TO_STRING(MWRes_UnrecognizedHeaderType)},
    {MWRes_ProductNotExpectedSize,
        MACRO_TO_STRING(MWRes_ProductNotExpectedSize)},
    {MWRes_UnrecognizedTransmogrificationType,
        MACRO_TO_STRING(MWRes_UnrecognizedTransmogrificationType)},
    {MWRes_ProductContentsInvalid,
        MACRO_TO_STRING(MWRes_ProductContentsInvalid)},
    {MWRes_TransportProtocolError,
        MACRO_TO_STRING(MWRes_TransportProtocolError)},
    {MWRes_ProductHeaderFieldInvalid,
        MACRO_TO_STRING(MWRes_ProductHeaderFieldInvalid)},
    {MWRes_OutOfMemory,
        MACRO_TO_STRING(MWRes_OutOfMemory)},
    {MWRes_CodeFault,
        MACRO_TO_STRING(MWRes_CodeFault)}
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* WSI_PLATFORM_PORT_H_ */
