/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _WS_ALERTS_LOCATION_OBJ_H_
#define _WS_ALERTS_LOCATION_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define WS_ALERTS_LOCATION_OBJECT_NAME "WS_ALERTS_LOCATION"


  /**************/
 /** TYPEDEFS **/
/**************/

// Private object structure
typedef struct ws_alerts_locations_object_struct
{
    LOC_ID tLocId;           // LocID (Type + Tabindex + Lcode)
    STRING_OBJECT hInfo;
    STRING_OBJECT hExtRef;
    STRING_OBJECT hExtType;
    SHAPE_OBJECT hShape;
    BOOLEAN bIsPolygon;      // TRUE if location is free polygon
    WS_ALERT_MSG_ID tMsgId;          // applicable only to free polygon
} WS_ALERTS_LOCATION_OBJECT_STRUCT;


//Public prototypes

static SHAPE_OBJECT hShape (
    WS_ALERTS_LOCATION_OBJECT hWsAlertsLocation
        );

static STRING_OBJECT hLocationExtType (
    WS_ALERTS_LOCATION_OBJECT hWsAlertsLocation
        );

static STRING_OBJECT hDescription (
    WS_ALERTS_LOCATION_OBJECT hWsAlertsLocation
        );

static N32 n32FPrintf (
    WS_ALERTS_LOCATION_OBJECT hWsAlertsLocation,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

//Private prototypes
static void vDestroyObject (
    WS_ALERTS_LOCATION_OBJECT_STRUCT *psObj
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const WS_ALERTS_LOCATION_INTERFACE_STRUCT WS_ALERTS_LOCATION =
{
    /* hShape = */ hShape,
    /* hLocationExtType = */ hLocationExtType,
    /* hDescription = */ hDescription,
    /* n32FPrintf = */ n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _WS_ALERTS_LOCATION_OBJ_H_
